/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import java.io.File;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.IntegerPattern;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.type.NativeType;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.spimdata.imgloaders.AbstractImgFactoryImgLoader;

public abstract class LegacyStackImgLoader
extends AbstractImgFactoryImgLoader {
    protected File path = null;
    protected String fileNamePattern = null;
    protected String replaceTimepoints;
    protected String replaceChannels;
    protected String replaceIlluminations;
    protected String replaceAngles;
    protected int numDigitsTimepoints;
    protected int numDigitsChannels;
    protected int numDigitsIlluminations;
    protected int numDigitsAngles;
    protected int layoutTP;
    protected int layoutChannels;
    protected int layoutIllum;
    protected int layoutAngles;
    protected AbstractSequenceDescription<?, ?, ?> sequenceDescription;

    public File getPath() {
        return this.path;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public int getLayoutTimePoints() {
        return this.layoutTP;
    }

    public int getLayoutChannels() {
        return this.layoutChannels;
    }

    public int getLayoutIlluminations() {
        return this.layoutIllum;
    }

    public int getLayoutAngles() {
        return this.layoutAngles;
    }

    protected <T extends NativeType<T>> Img<T> instantiateImg(long[] dim, T type) {
        Img img;
        try {
            img = this.getImgFactory().imgFactory(type).create(dim, type);
        }
        catch (Exception e1) {
            try {
                img = new CellImgFactory(new int[]{256}).create(dim, type);
            }
            catch (Exception e2) {
                img = null;
            }
        }
        return img;
    }

    protected File getFile(ViewId view) {
        String[] fileName;
        TimePoint tp = (TimePoint)this.sequenceDescription.getTimePoints().getTimePoints().get(view.getTimePointId());
        BasicViewSetup vs = (BasicViewSetup)this.sequenceDescription.getViewSetups().get(view.getViewSetupId());
        String timepoint = tp.getName();
        String angle = ((Angle)vs.getAttribute(Angle.class)).getName();
        String channel = ((Channel)vs.getAttribute(Channel.class)).getName();
        String illum = ((Illumination)vs.getAttribute(Illumination.class)).getName();
        for (String fn : fileName = StackList.getFileNamesFor(this.fileNamePattern, this.replaceTimepoints, this.replaceChannels, this.replaceIlluminations, this.replaceAngles, timepoint, channel, illum, angle, this.numDigitsTimepoints, this.numDigitsChannels, this.numDigitsIlluminations, this.numDigitsAngles)) {
            File f = new File(this.path, fn);
            if (f.exists()) {
                return f;
            }
            IOFunctions.printlnSafe("File '" + f.getAbsolutePath() + "' does not exist.");
        }
        IOFunctions.printlnSafe("Could not find file for tp=" + timepoint + ", angle=" + angle + ", channel=" + channel + ", ill=" + illum);
        return null;
    }

    public LegacyStackImgLoader(File path, String fileNamePattern, ImgFactory<? extends NativeType<?>> imgFactory, int layoutTP, int layoutChannels, int layoutIllum, int layoutAngles, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this.path = path;
        this.fileNamePattern = fileNamePattern;
        this.layoutTP = layoutTP;
        this.layoutChannels = layoutChannels;
        this.layoutIllum = layoutIllum;
        this.layoutAngles = layoutAngles;
        this.sequenceDescription = sequenceDescription;
        this.init(imgFactory);
    }

    protected void init(ImgFactory<? extends NativeType<?>> imgFactory) {
        this.setImgFactory(imgFactory);
        this.replaceAngles = null;
        this.replaceIlluminations = null;
        this.replaceChannels = null;
        this.replaceTimepoints = null;
        this.numDigitsAngles = -1;
        this.numDigitsIlluminations = -1;
        this.numDigitsChannels = -1;
        this.numDigitsTimepoints = -1;
        this.replaceTimepoints = IntegerPattern.getReplaceString((String)this.fileNamePattern, (char)'t');
        this.replaceChannels = IntegerPattern.getReplaceString((String)this.fileNamePattern, (char)'c');
        this.replaceIlluminations = IntegerPattern.getReplaceString((String)this.fileNamePattern, (char)'i');
        this.replaceAngles = IntegerPattern.getReplaceString((String)this.fileNamePattern, (char)'a');
        if (this.replaceTimepoints != null) {
            this.numDigitsTimepoints = this.replaceTimepoints.length() - 2;
        }
        if (this.replaceChannels != null) {
            this.numDigitsChannels = this.replaceChannels.length() - 2;
        }
        if (this.replaceIlluminations != null) {
            this.numDigitsIlluminations = this.replaceIlluminations.length() - 2;
        }
        if (this.replaceAngles != null) {
            this.numDigitsAngles = this.replaceAngles.length() - 2;
        }
    }
}

