/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.Opener;
import ij.process.ImageProcessor;
import java.io.File;
import java.util.Date;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.RealUnsignedShortConverter;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.fiji.datasetmanager.StackListImageJ;
import spim.fiji.plugin.resave.Generic_Resave_HDF5;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.imgloaders.LegacyStackImgLoader;
import spim.process.fusion.export.ExportSpimData2HDF5;

public class LegacyStackImgLoaderIJ
extends LegacyStackImgLoader {
    Generic_Resave_HDF5.Parameters params = null;

    public LegacyStackImgLoaderIJ(File path, String fileNamePattern, ImgFactory<? extends NativeType<?>> imgFactory, int layoutTP, int layoutChannels, int layoutIllum, int layoutAngles, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        super(path, fileNamePattern, imgFactory, layoutTP, layoutChannels, layoutIllum, layoutAngles, sequenceDescription);
    }

    public static ImagePlus open(File file) {
        ImagePlus imp = new Opener().openImage(file.getAbsolutePath());
        if (imp == null) {
            IOFunctions.printlnSafe("Could not open file with ImageJ TIFF reader: '" + file.getAbsolutePath() + "'");
            return null;
        }
        return imp;
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(ViewId view, boolean normalize) {
        File file = this.getFile(view);
        if (file == null) {
            throw new RuntimeException("Could not find file '" + file + "'.");
        }
        IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Loading '" + file + "' ...");
        ImagePlus imp = LegacyStackImgLoaderIJ.open(file);
        if (imp == null) {
            throw new RuntimeException("Could not load '" + file + "'.");
        }
        long[] dim = new long[]{imp.getWidth(), imp.getHeight(), imp.getStack().getSize()};
        Img<FloatType> img = this.instantiateImg(dim, new FloatType());
        if (img == null) {
            throw new RuntimeException("Could not instantiate " + this.getImgFactory().getClass().getSimpleName() + " for '" + file + "', most likely out of memory.");
        }
        IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Opened '" + file + "' [" + dim[0] + "x" + dim[1] + "x" + dim[2] + " image=" + img.getClass().getSimpleName() + "<FloatType>]");
        LegacyStackImgLoaderIJ.imagePlus2ImgLib2Img(imp, img, normalize);
        this.updateMetaDataCache(view, imp.getWidth(), imp.getHeight(), imp.getStack().getSize(), imp.getCalibration().pixelWidth, imp.getCalibration().pixelHeight, imp.getCalibration().pixelDepth);
        imp.close();
        return img;
    }

    public static void imagePlus2ImgLib2Img(ImagePlus imp, Img<FloatType> img, boolean normalize) {
        ImageStack stack = imp.getStack();
        int sizeZ = imp.getStack().getSize();
        if (img instanceof ArrayImg || img instanceof PlanarImg) {
            Cursor cursor = img.cursor();
            int sizeXY = imp.getWidth() * imp.getHeight();
            if (normalize) {
                float min = Float.MAX_VALUE;
                float max = -3.4028235E38f;
                for (int z = 0; z < sizeZ; ++z) {
                    ImageProcessor ip = stack.getProcessor(z + 1);
                    for (int i = 0; i < sizeXY; ++i) {
                        float v = ip.getf(i);
                        if (v < min) {
                            min = v;
                        }
                        if (v > max) {
                            max = v;
                        }
                        ((FloatType)cursor.next()).set(v);
                    }
                }
                for (FloatType t : img) {
                    t.set((t.get() - min) / (max - min));
                }
            } else {
                for (int z = 0; z < sizeZ; ++z) {
                    ImageProcessor ip = stack.getProcessor(z + 1);
                    for (int i = 0; i < sizeXY; ++i) {
                        ((FloatType)cursor.next()).set(ip.getf(i));
                    }
                }
            }
        } else {
            int width = imp.getWidth();
            if (normalize) {
                float min = Float.MAX_VALUE;
                float max = -3.4028235E38f;
                for (int z = 0; z < sizeZ; ++z) {
                    Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.hyperSlice(img, (int)2, (long)z)).localizingCursor();
                    ImageProcessor ip = stack.getProcessor(z + 1);
                    while (cursor.hasNext()) {
                        cursor.fwd();
                        float v = ip.getf(cursor.getIntPosition(0) + cursor.getIntPosition(1) * width);
                        if (v < min) {
                            min = v;
                        }
                        if (v > max) {
                            max = v;
                        }
                        ((FloatType)cursor.get()).set(v);
                    }
                }
                for (FloatType t : img) {
                    t.set((t.get() - min) / (max - min));
                }
            } else {
                for (int z = 0; z < sizeZ; ++z) {
                    Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.hyperSlice(img, (int)2, (long)z)).localizingCursor();
                    ImageProcessor ip = stack.getProcessor(z + 1);
                    while (cursor.hasNext()) {
                        cursor.fwd();
                        ((FloatType)cursor.get()).set(ip.getf(cursor.getIntPosition(0) + cursor.getIntPosition(1) * width));
                    }
                }
            }
        }
    }

    public RandomAccessibleInterval<UnsignedShortType> getImage(ViewId view) {
        RealUnsignedShortConverter converter;
        boolean is32bit;
        File file = this.getFile(view);
        if (file == null) {
            throw new RuntimeException("Could not find file '" + file + "'.");
        }
        IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Loading '" + file + "' ...");
        ImagePlus imp = LegacyStackImgLoaderIJ.open(file);
        if (imp == null) {
            throw new RuntimeException("Could not load '" + file + "'.");
        }
        if (imp.getType() == 2) {
            is32bit = true;
            IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Image '" + file + "' is 32bit, opening as 16bit with scaling");
            if (this.params == null) {
                this.params = LegacyStackImgLoaderIJ.queryParameters();
            }
            if (this.params == null) {
                return null;
            }
            double[] minmax = ExportSpimData2HDF5.updateAndGetMinMax(ImageJFunctions.wrapFloat((ImagePlus)imp), this.params);
            converter = new RealUnsignedShortConverter(minmax[0], minmax[1]);
        } else {
            is32bit = false;
            converter = null;
        }
        long[] dim = new long[]{imp.getWidth(), imp.getHeight(), imp.getStack().getSize()};
        Img<UnsignedShortType> img = this.instantiateImg(dim, new UnsignedShortType());
        if (img == null) {
            throw new RuntimeException("Could not instantiate " + this.getImgFactory().getClass().getSimpleName() + " for '" + file + "', most likely out of memory.");
        }
        IOFunctions.printlnSafe(new Date(System.currentTimeMillis()) + ": Opened '" + file + "' [" + dim[0] + "x" + dim[1] + "x" + dim[2] + " image=" + img.getClass().getSimpleName() + "<UnsignedShortType>]");
        ImageStack stack = imp.getStack();
        int sizeZ = imp.getStack().getSize();
        if (img instanceof ArrayImg || img instanceof PlanarImg) {
            Cursor cursor = img.cursor();
            int sizeXY = imp.getWidth() * imp.getHeight();
            for (int z = 0; z < sizeZ; ++z) {
                ImageProcessor ip = stack.getProcessor(z + 1);
                if (is32bit) {
                    FloatType input = new FloatType();
                    UnsignedShortType output = new UnsignedShortType();
                    for (int i = 0; i < sizeXY; ++i) {
                        input.set(ip.getf(i));
                        converter.convert((RealType)input, output);
                        ((UnsignedShortType)cursor.next()).set(output.get());
                    }
                    continue;
                }
                for (int i = 0; i < sizeXY; ++i) {
                    ((UnsignedShortType)cursor.next()).set(ip.get(i));
                }
            }
        } else {
            int width = imp.getWidth();
            for (int z = 0; z < sizeZ; ++z) {
                Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.hyperSlice(img, (int)2, (long)z)).localizingCursor();
                ImageProcessor ip = stack.getProcessor(z + 1);
                if (is32bit) {
                    FloatType input = new FloatType();
                    UnsignedShortType output = new UnsignedShortType();
                    while (cursor.hasNext()) {
                        cursor.fwd();
                        input.set(ip.getf(cursor.getIntPosition(0) + cursor.getIntPosition(1) * width));
                        converter.convert((RealType)input, output);
                        ((UnsignedShortType)cursor.get()).set((GenericShortType)output);
                    }
                    continue;
                }
                while (cursor.hasNext()) {
                    cursor.fwd();
                    ((UnsignedShortType)cursor.get()).set(ip.get(cursor.getIntPosition(0) + cursor.getIntPosition(1) * width));
                }
            }
        }
        this.updateMetaDataCache(view, imp.getWidth(), imp.getHeight(), imp.getStack().getSize(), imp.getCalibration().pixelWidth, imp.getCalibration().pixelHeight, imp.getCalibration().pixelDepth);
        imp.close();
        return img;
    }

    @Override
    protected void loadMetaData(ViewId view) {
        File file = this.getFile(view);
        ImagePlus imp = LegacyStackImgLoaderIJ.open(file);
        if (imp == null) {
            throw new RuntimeException("Could not load '" + file + "'.");
        }
        this.updateMetaDataCache(view, imp.getWidth(), imp.getHeight(), imp.getStack().getSize(), imp.getCalibration().pixelWidth, imp.getCalibration().pixelHeight, imp.getCalibration().pixelDepth);
        imp.close();
    }

    public String toString() {
        return new StackListImageJ().getTitle() + ", ImgFactory=" + this.imgFactory.getClass().getSimpleName();
    }

    protected static Generic_Resave_HDF5.Parameters queryParameters() {
        GenericDialog gd = new GenericDialog("Opening 32bit TIFF as 16bit");
        gd.addMessage("You are trying to open 32-bit images as 16-bit (resaving as HDF5 maybe). Please define how to convert to 16bit.", GUIHelper.mediumstatusfont);
        gd.addMessage("Note: This dialog will only show up once for the first image.", GUIHelper.mediumstatusfont);
        gd.addChoice("Convert_32bit", Generic_Resave_HDF5.convertChoices, Generic_Resave_HDF5.convertChoices[Generic_Resave_HDF5.defaultConvertChoice]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        Generic_Resave_HDF5.defaultConvertChoice = gd.getNextChoiceIndex();
        if (Generic_Resave_HDF5.defaultConvertChoice == 2) {
            if (Double.isNaN(Generic_Resave_HDF5.defaultMin)) {
                Generic_Resave_HDF5.defaultMin = 0.0;
            }
            if (Double.isNaN(Generic_Resave_HDF5.defaultMax)) {
                Generic_Resave_HDF5.defaultMax = 5.0;
            }
            GenericDialog gdMinMax = new GenericDialog("Define min/max");
            gdMinMax.addNumericField("Min_Intensity_for_16bit_conversion", Generic_Resave_HDF5.defaultMin, 1);
            gdMinMax.addNumericField("Max_Intensity_for_16bit_conversion", Generic_Resave_HDF5.defaultMax, 1);
            gdMinMax.addMessage("Note: the typical range for multiview deconvolution is [0 ... 10] & for fusion the same as the input intensities., ", GUIHelper.mediumstatusfont);
            gdMinMax.showDialog();
            if (gdMinMax.wasCanceled()) {
                return null;
            }
            Generic_Resave_HDF5.defaultMin = gdMinMax.getNextNumber();
            Generic_Resave_HDF5.defaultMax = gdMinMax.getNextNumber();
        } else {
            Generic_Resave_HDF5.defaultMax = Double.NaN;
            Generic_Resave_HDF5.defaultMin = Double.NaN;
        }
        return new Generic_Resave_HDF5.Parameters(false, null, null, null, null, false, false, 0, 0, false, 0, Generic_Resave_HDF5.defaultConvertChoice, Generic_Resave_HDF5.defaultMin, Generic_Resave_HDF5.defaultMax);
    }
}

