/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import java.io.File;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import net.imglib2.img.array.ArrayImgFactory;
import org.jdom2.Content;
import org.jdom2.Element;
import spim.fiji.spimdata.imgloaders.MicroManagerImgLoader;

@ImgLoaderIo(format="spimreconstruction.micromanager", type=MicroManagerImgLoader.class)
public class XmlIoMicroManagerImgLoader
implements XmlIoBasicImgLoader<MicroManagerImgLoader> {
    public static final String DIRECTORY_TAG = "imagedirectory";
    public static final String MASTER_FILE_TAG = "masterfile";
    public static final String IMGLIB2CONTAINER_PATTERN_TAG = "imglib2container";

    public Element toXml(MicroManagerImgLoader imgLoader, File basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", this.getClass().getAnnotation(ImgLoaderIo.class).format());
        elem.addContent((Content)XmlHelpers.pathElement((String)DIRECTORY_TAG, (File)imgLoader.getFile().getParentFile(), (File)basePath));
        elem.addContent((Content)XmlHelpers.textElement((String)MASTER_FILE_TAG, (String)imgLoader.getFile().getName()));
        elem.addContent((Content)XmlHelpers.textElement((String)IMGLIB2CONTAINER_PATTERN_TAG, (String)ArrayImgFactory.class.getSimpleName()));
        return elem;
    }

    public MicroManagerImgLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        try {
            File path = XmlHelpers.loadPath((Element)elem, (String)DIRECTORY_TAG, (File)basePath);
            String masterFile = XmlHelpers.getText((Element)elem, (String)MASTER_FILE_TAG);
            String container = XmlHelpers.getText((Element)elem, (String)IMGLIB2CONTAINER_PATTERN_TAG);
            if (container == null) {
                System.out.println("WARNING: No Img implementation defined in XML, using ArrayImg.");
            } else if (!container.toLowerCase().contains("arrayimg")) {
                System.out.println("WARNING: Only ArrayImg supported for MicroManager ImgLoader, using ArrayImg.");
            }
            return new MicroManagerImgLoader(new File(path, masterFile), sequenceDescription);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

