/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.boundingbox;

import bdv.BigDataViewer;
import bdv.export.ProgressWriter;
import bdv.tools.InitializeViewerState;
import bdv.tools.boundingbox.BoundingBoxDialog;
import bdv.tools.brightness.SetupAssignments;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ViewerOptions;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import spim.fiji.plugin.apply.BigDataViewerTransformationWindow;
import spim.fiji.plugin.fusion.Fusion;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.BDVPopup;
import spim.fiji.spimdata.imgloaders.AbstractImgLoader;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.export.ImgExport;

public class BigDataViewerBoundingBox
extends BoundingBoxGUI {
    public BigDataViewerBoundingBox(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        super(spimData, viewIdsToProcess);
    }

    public static Pair<BigDataViewer, Boolean> getBDV(AbstractSpimData<?> spimData, Collection<ViewId> viewIdsToProcess) {
        BigDataViewer bdv;
        BDVPopup popup = ViewSetupExplorerPanel.bdvPopup();
        boolean bdvIsLocal = false;
        if (popup == null || popup.panel == null) {
            if (AbstractImgLoader.class.isInstance(spimData.getSequenceDescription().getImgLoader()) && JOptionPane.showConfirmDialog(null, "Opening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.\nProceed anyways?", "Warning", 0) == 1) {
                return null;
            }
            bdv = BigDataViewer.open(spimData, (String)"BigDataViewer", (ProgressWriter)IOFunctions.getProgressWriter(), (ViewerOptions)ViewerOptions.options());
            bdvIsLocal = true;
            InitializeViewerState.initBrightness((double)0.001, (double)0.999, (AbstractViewerPanel)bdv.getViewer(), (SetupAssignments)bdv.getSetupAssignments());
            ArrayList vds = new ArrayList();
            for (ViewId viewId : viewIdsToProcess) {
                vds.add(spimData.getSequenceDescription().getViewDescriptions().get(viewId));
            }
            ViewSetupExplorerPanel.updateBDV(bdv, true, spimData, null, vds);
        } else if (popup.bdv == null) {
            if (popup.bdv != null && !popup.bdv.getViewerFrame().isVisible()) {
                popup.bdv = null;
            }
            try {
                bdv = popup.bdv = BDVPopup.createBDV(popup.panel);
            }
            catch (Exception e) {
                IOFunctions.println("Could not run BigDataViewer: " + e);
                e.printStackTrace();
                popup.bdv = null;
                bdv = null;
            }
        } else {
            bdv = popup.bdv;
        }
        return new ValuePair((Object)bdv, (Object)bdvIsLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean queryParameters(Fusion fusion, ImgExport imgExport) {
        Pair<BigDataViewer, Boolean> bdvPair = BigDataViewerBoundingBox.getBDV(this.spimData, this.viewIdsToProcess);
        if (bdvPair == null || bdvPair.getA() == null) {
            return false;
        }
        BigDataViewer bdv = (BigDataViewer)bdvPair.getA();
        final AtomicBoolean lock = new AtomicBoolean(false);
        int[] rangeMin = new int[3];
        int[] rangeMax = new int[3];
        this.setUpDefaultValues(rangeMin, rangeMax);
        int boxSetupId = 9999;
        FinalInterval initialInterval = Intervals.createMinMax((long[])new long[]{this.min[0], this.min[1], this.min[2], this.max[0], this.max[1], this.max[2]});
        FinalInterval rangeInterval = Intervals.createMinMax((long[])new long[]{rangeMin[0], rangeMin[1], rangeMin[2], rangeMax[0], rangeMax[1], rangeMax[2]});
        BoundingBoxDialog boundingBoxDialog = new BoundingBoxDialog((Frame)bdv.getViewerFrame(), "bounding box", bdv.getViewer(), bdv.getSetupAssignments(), 9999, (Interval)initialInterval, (Interval)rangeInterval){
            private static final long serialVersionUID = 1L;

            public void createContent() {
                JButton button = new JButton("ok");
                button.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = 1L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.setVisible(false);
                        for (int d = 0; d < BigDataViewerBoundingBox.this.min.length; ++d) {
                            ((BigDataViewerBoundingBox)BigDataViewerBoundingBox.this).min[d] = (int)Math.floor(boxRealRandomAccessible.getInterval().realMin(d));
                            ((BigDataViewerBoundingBox)BigDataViewerBoundingBox.this).max[d] = (int)Math.ceil(boxRealRandomAccessible.getInterval().realMax(d));
                        }
                        lock.set(true);
                        try {
                            AtomicBoolean atomicBoolean = lock;
                            synchronized (atomicBoolean) {
                                lock.notifyAll();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                this.getContentPane().add((Component)this.boxSelectionPanel, "North");
                this.getContentPane().add((Component)button, "South");
                this.pack();
            }
        };
        boundingBoxDialog.setVisible(true);
        do {
            try {
                AtomicBoolean atomicBoolean = lock;
                synchronized (atomicBoolean) {
                    lock.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!lock.get());
        IOFunctions.println("Min: " + Util.printCoordinates((int[])this.min));
        IOFunctions.println("Max: " + Util.printCoordinates((int[])this.max));
        BoundingBoxGUI.defaultMin = (int[])this.min.clone();
        BoundingBoxGUI.defaultMax = (int[])this.max.clone();
        if (((Boolean)bdvPair.getB()).booleanValue()) {
            BigDataViewerTransformationWindow.disposeViewerWindow(bdv);
        }
        return super.queryParameters(fusion, imgExport);
    }

    @Override
    public BigDataViewerBoundingBox newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess) {
        return new BigDataViewerBoundingBox(spimData, viewIdsToProcess);
    }

    @Override
    public String getDescription() {
        return "Define with BigDataViewer";
    }
}

