/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.spim.io.IOFunctions;
import mpicbg.util.RealSum;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.real.FloatType;
import spim.Threads;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;

public class AdjustInput {
    public static Random rnd = new Random(14235235L);

    public static final void normImg(IterableInterval<FloatType> img) {
        double sum = AdjustInput.sumImg(img);
        for (FloatType t : img) {
            t.set((float)((double)t.get() / sum));
        }
    }

    public static final double sumImg(final IterableInterval<FloatType> img) {
        int numPortions = Threads.numThreads() * 2;
        final RealSum[] sums = new RealSum[numPortions];
        final AtomicInteger ai = new AtomicInteger(0);
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(img.size(), numPortions);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList<1> tasks = new ArrayList<1>();
        for (final ImagePortion portion : portions) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int id = ai.getAndIncrement();
                    RealSum sum = new RealSum();
                    Cursor c = img.cursor();
                    c.jumpFwd(portion.getStartPosition());
                    for (long j = 0L; j < portion.getLoopSize(); ++j) {
                        sum.add((double)((FloatType)c.next()).get());
                    }
                    sums[id] = sum;
                    return null;
                }
            });
        }
        try {
            taskExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            IOFunctions.println("Failed to compute sumImage: " + e);
            e.printStackTrace();
            return Double.NaN;
        }
        taskExecutor.shutdown();
        RealSum sum = new RealSum();
        sum.add(sums[0].getSum());
        for (RealSum s : sums) {
            sum.add(s.getSum());
        }
        return sum.getSum();
    }
}

