/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weightedavg;

import java.util.ArrayList;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.img.Img;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.boundingbox.BoundingBoxGUI;
import spim.process.fusion.weightedavg.ProcessParalellPortion;

public class ProcessSequentialPortion<T extends RealType<T>>
extends ProcessParalellPortion<T> {
    final Img<FloatType> weightImg;

    public ProcessSequentialPortion(ImagePortion portion, ArrayList<RandomAccessibleInterval<T>> imgs, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, AffineTransform3D[] transforms, Img<T> fusedImg, Img<FloatType> weightImg, BoundingBoxGUI bb) {
        super(portion, imgs, interpolatorFactory, transforms, fusedImg, bb);
        this.weightImg = weightImg;
    }

    @Override
    public String call() throws Exception {
        int numViews = this.imgs.size();
        ArrayList<RealRandomAccess> interpolators = new ArrayList<RealRandomAccess>(numViews);
        int[][] imgSizes = new int[numViews][3];
        for (int i = 0; i < numViews; ++i) {
            RandomAccessibleInterval img = (RandomAccessibleInterval)this.imgs.get(i);
            imgSizes[i] = new int[]{(int)img.dimension(0), (int)img.dimension(1), (int)img.dimension(2)};
            interpolators.add(Views.interpolate((EuclideanSpace)Views.extendMirrorSingle((RandomAccessibleInterval)img), (InterpolatorFactory)this.interpolatorFactory).realRandomAccess());
        }
        Cursor cursor = this.fusedImg.localizingCursor();
        Cursor cursorW = this.weightImg.cursor();
        float[] s = new float[3];
        float[] t = new float[3];
        cursor.jumpFwd(this.portion.getStartPosition());
        cursorW.jumpFwd(this.portion.getStartPosition());
        int j = 0;
        while ((long)j < this.portion.getLoopSize()) {
            RealType v = (RealType)cursor.next();
            cursor.localize(s);
            FloatType w = (FloatType)cursorW.next();
            if (this.doDownSampling) {
                s[0] = s[0] * (float)this.downSampling;
                s[1] = s[1] * (float)this.downSampling;
                s[2] = s[2] * (float)this.downSampling;
            }
            s[0] = s[0] + (float)this.bb.min(0);
            s[1] = s[1] + (float)this.bb.min(1);
            s[2] = s[2] + (float)this.bb.min(2);
            double sum = 0.0;
            int sumW = 0;
            for (int i = 0; i < numViews; ++i) {
                this.transforms[i].applyInverse(t, s);
                if (!FusionHelper.intersects(t[0], t[1], t[2], imgSizes[i][0], imgSizes[i][1], imgSizes[i][2])) continue;
                RealRandomAccess r = (RealRandomAccess)interpolators.get(i);
                r.setPosition(t);
                sum += ((RealType)r.get()).getRealDouble();
                ++sumW;
            }
            if (sumW > 0) {
                v.setReal((double)v.getRealFloat() + sum);
                w.set(w.get() + (float)sumW);
            }
            ++j;
        }
        return this.portion + " finished successfully (no weights).";
    }
}

