/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointdetection;

import ij.ImageJ;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.iterator.ZeroMinIntervalIterator;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import spim.Threads;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;

public class Downsample {
    public static <T extends RealType<T>> RandomAccessibleInterval<T> simple2x(RandomAccessibleInterval<T> input, ImgFactory<T> imgFactory) {
        boolean[] downsampleInDim = new boolean[input.numDimensions()];
        for (int d = 0; d < downsampleInDim.length; ++d) {
            downsampleInDim[d] = true;
        }
        return Downsample.simple2x(input, imgFactory, downsampleInDim);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> simple2x(RandomAccessibleInterval<T> input, ImgFactory<T> imgFactory, boolean[] downsampleInDim) {
        Img src = input;
        for (int d = 0; d < input.numDimensions(); ++d) {
            if (!downsampleInDim[d]) continue;
            long[] dim = new long[input.numDimensions()];
            for (int e = 0; e < input.numDimensions(); ++e) {
                dim[e] = e == d ? src.dimension(e) / 2L : src.dimension(e);
            }
            Img img = imgFactory.create(dim, Views.iterable(input).firstElement());
            Downsample.simple2x(src, img, d);
            src = img;
        }
        return src;
    }

    public static <T extends RealType<T>> void simple2x(final RandomAccessibleInterval<T> input, final RandomAccessibleInterval<T> output, final int d) {
        final int n = input.numDimensions();
        final long[] iterateD = new long[n];
        long numLines = 1L;
        for (int e = 0; e < n; ++e) {
            iterateD[e] = e == d ? 1L : output.dimension(e);
            numLines *= iterateD[e];
        }
        Vector<ImagePortion> portions = FusionHelper.divideIntoPortions(numLines, Threads.numThreads() * 2);
        ExecutorService taskExecutor = Executors.newFixedThreadPool(Threads.numThreads());
        ArrayList<1> tasks = new ArrayList<1>();
        for (final ImagePortion portion : portions) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    long[] pos = new long[n];
                    ZeroMinIntervalIterator cursorDim = new ZeroMinIntervalIterator(iterateD);
                    RandomAccess in = Views.zeroMin((RandomAccessibleInterval)input).randomAccess();
                    RandomAccess out = Views.zeroMin((RandomAccessibleInterval)output).randomAccess();
                    long size = output.dimension(d) - 1L;
                    cursorDim.jumpFwd(portion.getStartPosition());
                    for (long j = 0L; j < portion.getLoopSize(); ++j) {
                        double v2;
                        cursorDim.fwd();
                        cursorDim.localize(pos);
                        out.setPosition(pos);
                        in.setPosition(pos);
                        double v1 = ((RealType)in.get()).getRealDouble();
                        in.fwd(d);
                        double v0 = v2 = ((RealType)in.get()).getRealDouble();
                        ((RealType)out.get()).setReal((v1 + v2 * 0.5) / 1.5);
                        int p = 1;
                        while ((long)p < size) {
                            v0 = v2;
                            in.fwd(d);
                            v1 = ((RealType)in.get()).getRealDouble();
                            in.fwd(d);
                            v2 = ((RealType)in.get()).getRealDouble();
                            out.fwd(d);
                            ((RealType)out.get()).setReal((v0 * 0.5 + v1 + v2 * 0.5) / 2.0);
                            ++p;
                        }
                        in.fwd(d);
                        v1 = ((RealType)in.get()).getRealDouble();
                        out.fwd(d);
                        ((RealType)out.get()).setReal((v1 + v2 * 0.5) / 1.5);
                    }
                    return null;
                }
            });
        }
        try {
            taskExecutor.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            IOFunctions.println("Failed to compute downsampling: " + e);
            e.printStackTrace();
            return;
        }
        taskExecutor.shutdown();
    }

    public static void main(String[] args) {
        ArrayImg img = new ArrayImgFactory().create(new long[]{515L, 231L, 15L}, (NativeType)new FloatType());
        Cursor c = img.localizingCursor();
        while (c.hasNext()) {
            ((FloatType)c.next()).set((float)(c.getIntPosition(0) % 10 + c.getIntPosition(1) % 13 + c.getIntPosition(2) % 3));
        }
        new ImageJ();
        ImageJFunctions.show((RandomAccessibleInterval)img);
        ImageJFunctions.show(Downsample.simple2x(img, img.factory(), new boolean[]{true, true, true}));
    }
}

