/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.geometricdescriptor;

import fiji.util.KDTree;
import fiji.util.NNearestNeighborSearch;
import fiji.util.node.Leaf;
import java.util.ArrayList;
import mpicbg.pointdescriptor.AbstractPointDescriptor;
import mpicbg.pointdescriptor.SimplePointDescriptor;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.pointdescriptor.matcher.Matcher;
import mpicbg.pointdescriptor.matcher.SubsetMatcher;
import mpicbg.pointdescriptor.similarity.SimilarityMeasure;
import mpicbg.pointdescriptor.similarity.SquareDistance;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import spim.process.interestpointregistration.Detection;

public class RGLDMMatcher {
    public ArrayList<PointMatchGeneric<Detection>> extractCorrespondenceCandidates(ArrayList<Detection> nodeListA, ArrayList<Detection> nodeListB, int numNeighbors, int redundancy, double ratioOfDistance, double differenceThreshold) {
        KDTree treeA = new KDTree(nodeListA);
        KDTree treeB = new KDTree(nodeListB);
        SubsetMatcher matcher = new SubsetMatcher(numNeighbors, numNeighbors + redundancy);
        int numRequiredNeighbors = matcher.getRequiredNumNeighbors();
        SquareDistance similarityMeasure = new SquareDistance();
        ArrayList<SimplePointDescriptor<Detection>> descriptorsA = RGLDMMatcher.createSimplePointDescriptors((KDTree<Detection>)treeA, nodeListA, numRequiredNeighbors, matcher, similarityMeasure);
        ArrayList<SimplePointDescriptor<Detection>> descriptorsB = RGLDMMatcher.createSimplePointDescriptors((KDTree<Detection>)treeB, nodeListB, numRequiredNeighbors, matcher, similarityMeasure);
        return RGLDMMatcher.findCorrespondingDescriptors(descriptorsA, descriptorsB, ratioOfDistance, differenceThreshold);
    }

    protected static final <D extends AbstractPointDescriptor<Detection, D>> ArrayList<PointMatchGeneric<Detection>> findCorrespondingDescriptors(ArrayList<D> descriptorsA, ArrayList<D> descriptorsB, double nTimesBetter, double differenceThreshold) {
        ArrayList<PointMatchGeneric<Detection>> correspondenceCandidates = new ArrayList<PointMatchGeneric<Detection>>();
        for (AbstractPointDescriptor descriptorA : descriptorsA) {
            double bestDifference = Double.MAX_VALUE;
            double secondBestDifference = Double.MAX_VALUE;
            AbstractPointDescriptor bestMatch = null;
            AbstractPointDescriptor secondBestMatch = null;
            for (AbstractPointDescriptor descriptorB : descriptorsB) {
                double difference = descriptorA.descriptorDistance(descriptorB);
                if (!(difference < secondBestDifference)) continue;
                secondBestDifference = difference;
                secondBestMatch = descriptorB;
                if (!(secondBestDifference < bestDifference)) continue;
                double tmpDiff = secondBestDifference;
                AbstractPointDescriptor tmpMatch = secondBestMatch;
                secondBestDifference = bestDifference;
                secondBestMatch = bestMatch;
                bestDifference = tmpDiff;
                bestMatch = tmpMatch;
            }
            if (!(bestDifference < differenceThreshold) || !(bestDifference * nTimesBetter < secondBestDifference)) continue;
            Detection detectionA = (Detection)((Object)descriptorA.getBasisPoint());
            Detection detectionB = (Detection)((Object)bestMatch.getBasisPoint());
            correspondenceCandidates.add(new PointMatchGeneric<Detection>(detectionA, detectionB));
        }
        return correspondenceCandidates;
    }

    protected static ArrayList<SimplePointDescriptor<Detection>> createSimplePointDescriptors(KDTree<Detection> tree, ArrayList<Detection> basisPoints, int numNeighbors, Matcher matcher, SimilarityMeasure similarityMeasure) {
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(tree);
        ArrayList<SimplePointDescriptor<Detection>> descriptors = new ArrayList<SimplePointDescriptor<Detection>>();
        for (Detection p : basisPoints) {
            ArrayList<Detection> neighbors = new ArrayList<Detection>();
            Detection[] neighborList = (Detection[])nnsearch.findNNearestNeighbors((Leaf)p, numNeighbors + 1);
            for (int n = 1; n < neighborList.length; ++n) {
                neighbors.add(neighborList[n]);
            }
            try {
                descriptors.add(new SimplePointDescriptor<Detection>(p, neighbors, similarityMeasure, matcher));
            }
            catch (NoSuitablePointsException e) {
                e.printStackTrace();
            }
        }
        return descriptors;
    }
}

