/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.optimizationtypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mpicbg.models.AbstractModel;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import net.imglib2.realtransform.AffineTransform3D;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.CorrespondingInterestPoints;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.Detection;
import spim.process.interestpointregistration.MatchPointList;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationSubset;

public abstract class GlobalOptimizationType {
    protected final boolean considerTimePointsAsUnit;
    final SpimData2 spimData;
    final List<ViewId> viewIdsToProcess;
    final List<ChannelProcess> channelsToProcess;
    List<GlobalOptimizationSubset> subsets;
    Set<ViewId> fixedTiles;
    Map<GlobalOptimizationSubset, ViewId> referenceTiles;
    AbstractModel<?> mapBackModel;

    public GlobalOptimizationType(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess, boolean considerTimePointsAsUnit) {
        this.spimData = spimData;
        this.viewIdsToProcess = viewIdsToProcess;
        this.channelsToProcess = channelsToProcess;
        this.considerTimePointsAsUnit = considerTimePointsAsUnit;
        this.fixedTiles = new HashSet<ViewId>();
        this.referenceTiles = new HashMap<GlobalOptimizationSubset, ViewId>();
        this.mapBackModel = null;
        this.subsets = null;
    }

    protected abstract List<GlobalOptimizationSubset> assembleAllViewPairs();

    public List<GlobalOptimizationSubset> getAllViewPairs() {
        if (this.subsets == null) {
            this.subsets = this.assembleAllViewPairs();
        }
        return this.subsets;
    }

    public boolean isFixedTile(ViewId viewId) {
        return this.fixedTiles.contains(viewId);
    }

    public Set<ViewId> getFixedTiles() {
        return this.fixedTiles;
    }

    public void setFixedTiles(Set<ViewId> fixedTiles) {
        this.fixedTiles = fixedTiles;
    }

    public ViewId getMapBackReferenceTile(GlobalOptimizationSubset set) {
        return this.referenceTiles == null ? null : this.referenceTiles.get(set);
    }

    public void setMapBackReferenceTile(GlobalOptimizationSubset set, ViewId referenceTile) {
        if (this.referenceTiles == null) {
            this.referenceTiles = new HashMap<GlobalOptimizationSubset, ViewId>();
        }
        this.referenceTiles.put(set, referenceTile);
    }

    public void setMapBackReferenceTiles(Map<GlobalOptimizationSubset, ViewId> referenceTiles) {
        this.referenceTiles = referenceTiles;
    }

    public AbstractModel<?> getMapBackModel() {
        return this.mapBackModel;
    }

    public void setMapBackModel(AbstractModel<?> model) {
        this.mapBackModel = model;
    }

    public boolean considerTimePointsAsUnit() {
        return this.considerTimePointsAsUnit;
    }

    public SpimData2 getSpimData() {
        return this.spimData;
    }

    protected HashMap<ViewId, MatchPointList> getInterestPoints(TimePoint timepoint) {
        HashMap<ViewId, MatchPointList> interestPoints = new HashMap<ViewId, MatchPointList>();
        ViewRegistrations registrations = this.spimData.getViewRegistrations();
        ViewInterestPoints interestpoints = this.spimData.getViewInterestPoints();
        for (ViewDescription vd : SpimData2.getAllViewIdsForTimePointSorted(this.spimData, this.viewIdsToProcess, timepoint)) {
            ChannelProcess c;
            if (!vd.isPresent() || (c = GlobalOptimizationType.getChannelProcessForChannel(this.channelsToProcess, ((ViewSetup)vd.getViewSetup()).getChannel())) == null) continue;
            Angle a = ((ViewSetup)vd.getViewSetup()).getAngle();
            Illumination i = ((ViewSetup)vd.getViewSetup()).getIllumination();
            ArrayList<InterestPoint> list = new ArrayList<InterestPoint>();
            ViewInterestPointLists lists = interestpoints.getViewInterestPointLists((ViewId)vd);
            if (!lists.contains(c.getLabel())) {
                IOFunctions.println("Interest points for label '" + c.getLabel() + "' not found for timepoint: " + timepoint.getId() + " angle: " + a.getId() + " channel: " + c.getChannel().getId() + " illum: " + i.getId());
                continue;
            }
            if (lists.getInterestPointList(c.getLabel()).getInterestPoints() == null && !lists.getInterestPointList(c.getLabel()).loadInterestPoints()) {
                IOFunctions.println("Interest points for label '" + c.getLabel() + "' could not be loaded for timepoint: " + timepoint.getId() + " angle: " + a.getId() + " channel: " + c.getChannel().getId() + " illum: " + i.getId());
                continue;
            }
            List<InterestPoint> ptList = lists.getInterestPointList(c.getLabel()).getInterestPoints();
            ViewRegistration r = registrations.getViewRegistration((ViewId)vd);
            r.updateModel();
            AffineTransform3D m = r.getModel();
            for (InterestPoint p : ptList) {
                double[] l = new double[3];
                m.apply(p.getL(), l);
                list.add(new InterestPoint(p.getId(), l));
            }
            interestPoints.put((ViewId)vd, new MatchPointList(list, c));
        }
        return interestPoints;
    }

    protected static ChannelProcess getChannelProcessForChannel(List<ChannelProcess> cpList, Channel c) {
        for (ChannelProcess cp : cpList) {
            if (cp.getChannel().getId() != c.getId()) continue;
            return cp;
        }
        return null;
    }

    public void addCorrespondences(List<PairwiseMatch> pairs) {
        for (PairwiseMatch pair : pairs) {
            ArrayList<PointMatchGeneric<Detection>> correspondences = pair.getInliers();
            String labelA = pair.getChannelProcessedA().getLabel();
            String labelB = pair.getChannelProcessedB().getLabel();
            ViewId viewA = pair.getViewIdA();
            ViewId viewB = pair.getViewIdB();
            InterestPointList listA = this.spimData.getViewInterestPoints().getViewInterestPointLists(viewA).getInterestPointList(labelA);
            InterestPointList listB = this.spimData.getViewInterestPoints().getViewInterestPointLists(viewB).getInterestPointList(labelB);
            List<CorrespondingInterestPoints> corrListA = listA.getCorrespondingInterestPoints();
            List<CorrespondingInterestPoints> corrListB = listB.getCorrespondingInterestPoints();
            if (corrListA == null) {
                corrListA = new ArrayList<CorrespondingInterestPoints>();
            }
            if (corrListB == null) {
                corrListB = new ArrayList<CorrespondingInterestPoints>();
            }
            for (PointMatchGeneric<Detection> d : correspondences) {
                Detection dA = d.getPoint1();
                Detection dB = d.getPoint2();
                CorrespondingInterestPoints correspondingToA = new CorrespondingInterestPoints(dA.getId(), viewB, labelB, dB.getId());
                CorrespondingInterestPoints correspondingToB = new CorrespondingInterestPoints(dB.getId(), viewA, labelA, dA.getId());
                corrListA.add(correspondingToA);
                corrListB.add(correspondingToB);
            }
            listA.setCorrespondingInterestPoints(corrListA);
            listB.setCorrespondingInterestPoints(corrListB);
        }
    }

    public void saveCorrespondences(GlobalOptimizationSubset set) {
        for (ViewId id : set.getViews()) {
            for (ChannelProcess c : this.channelsToProcess) {
                if (((ViewSetup)((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(id).getViewSetup()).getChannel().getId() != c.getChannel().getId()) continue;
                this.spimData.getViewInterestPoints().getViewInterestPointLists(id).getInterestPointList(c.getLabel()).saveCorrespondingInterestPoints();
            }
        }
    }

    public void clearExistingCorrespondences(GlobalOptimizationSubset set) {
        for (ViewId id : set.getViews()) {
            for (ChannelProcess c : this.channelsToProcess) {
                if (((ViewSetup)((SequenceDescription)this.spimData.getSequenceDescription()).getViewDescription(id).getViewSetup()).getChannel().getId() != c.getChannel().getId()) continue;
                this.spimData.getViewInterestPoints().getViewInterestPointLists(id).getInterestPointList(c.getLabel()).setCorrespondingInterestPoints(new ArrayList<CorrespondingInterestPoints>());
            }
        }
    }

    protected static boolean isValid(ViewId viewId, MatchPointList list) {
        if (list == null) {
            IOFunctions.println("Interest points NOT found for timepoint=" + viewId.getTimePointId() + ", viewsetup=" + viewId.getViewSetupId());
            return false;
        }
        return true;
    }
}

