/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.optimizationtypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import spim.fiji.spimdata.SpimData2;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.MatchPointList;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationSubset;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationType;

public class ReferenceTimepointRegistration
extends GlobalOptimizationType {
    final TimePoint referenceTimepoint;

    public ReferenceTimepointRegistration(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess, TimePoint referenceTimepoint, boolean considerTimePointsAsUnit) {
        super(spimData, viewIdsToProcess, channelsToProcess, considerTimePointsAsUnit);
        this.setFixedTiles(ReferenceTimepointRegistration.assembleFixedTiles(spimData, viewIdsToProcess, channelsToProcess, referenceTimepoint));
        this.referenceTimepoint = referenceTimepoint;
    }

    protected static HashSet<ViewId> assembleFixedTiles(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess, TimePoint referenceTimepoint) {
        HashSet<ViewId> fixedTiles = new HashSet<ViewId>();
        for (ViewDescription vd : SpimData2.getAllViewIdsForTimePointSorted(spimData, viewIdsToProcess, referenceTimepoint)) {
            if (!vd.isPresent()) continue;
            for (ChannelProcess cp : channelsToProcess) {
                if (cp.getChannel().getId() != ((ViewSetup)vd.getViewSetup()).getChannel().getId()) continue;
                fixedTiles.add((ViewId)vd);
            }
        }
        return fixedTiles;
    }

    public TimePoint getReferenceTimepoint() {
        return this.referenceTimepoint;
    }

    @Override
    public List<GlobalOptimizationSubset> assembleAllViewPairs() {
        ArrayList<GlobalOptimizationSubset> list = new ArrayList<GlobalOptimizationSubset>();
        HashMap<ViewId, MatchPointList> pointListsReferenceTimepoint = this.getInterestPoints(this.referenceTimepoint);
        for (TimePoint timepoint : SpimData2.getAllTimePointsSorted(this.spimData, this.viewIdsToProcess)) {
            MatchPointList listB;
            int a;
            if (timepoint == this.referenceTimepoint) continue;
            HashMap<ViewId, MatchPointList> pointListsTimepoint = this.getInterestPoints(timepoint);
            ArrayList<ViewId> views = new ArrayList<ViewId>();
            views.addAll(pointListsTimepoint.keySet());
            Collections.sort(views);
            ArrayList<PairwiseMatch> viewPairs = new ArrayList<PairwiseMatch>();
            for (a = 0; a < views.size(); ++a) {
                MatchPointList listA;
                ViewId viewIdA = (ViewId)views.get(a);
                if (!ReferenceTimepointRegistration.isValid(viewIdA, listA = pointListsTimepoint.get(viewIdA))) continue;
                for (ViewId viewIdB : this.fixedTiles) {
                    if (!ReferenceTimepointRegistration.isValid(viewIdB, listB = pointListsReferenceTimepoint.get(viewIdB))) continue;
                    viewPairs.add(new PairwiseMatch(viewIdA, viewIdB, listA, listB));
                }
            }
            if (!this.considerTimePointsAsUnit()) {
                for (a = 0; a < views.size() - 1; ++a) {
                    for (int b = a + 1; b < views.size(); ++b) {
                        ViewId viewIdA = (ViewId)views.get(a);
                        ViewId viewIdB = (ViewId)views.get(b);
                        MatchPointList listA = pointListsTimepoint.get(viewIdA);
                        listB = pointListsTimepoint.get(viewIdB);
                        if (!ReferenceTimepointRegistration.isValid(viewIdA, listA) || !ReferenceTimepointRegistration.isValid(viewIdB, listB)) continue;
                        viewPairs.add(new PairwiseMatch(viewIdA, viewIdB, listA, listB));
                    }
                }
            }
            list.add(new GlobalOptimizationSubset(viewPairs, "reference timepoint ( " + this.referenceTimepoint.getName() + ", id=" + this.referenceTimepoint.getId() + ") registration: " + timepoint.getName() + "(id=" + timepoint.getId() + ")"));
        }
        return list;
    }

    @Override
    public ViewId getMapBackReferenceTile(GlobalOptimizationSubset set) {
        return null;
    }
}

