/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import ij.ImagePlus;
import ij.gui.NewImage;
import java.awt.Container;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import view5d.AnElement;
import view5d.ROI;

class ASlice {
    int[] mySlice;
    double[] my1DProj = null;
    public double[] DisplayOffset;
    int myDim;
    int AllSize;
    int SliceSizeX;
    int SliceSizeY;
    boolean isValid;
    int previousSlice;
    double ROISum = Double.NaN;
    double ROIAvg = Double.NaN;
    double ROIMax = Double.NaN;
    double ROIMin = Double.NaN;
    double ROIVoxels = Double.NaN;
    boolean MIPMode = true;
    ColorModel MyColorModel;
    int[] my1DProjVoxels = null;
    double Proj1DScale = 1.0;
    double Proj1DOffset = 0.0;

    ASlice(int mDim, AnElement myData) {
        this.myDim = mDim;
        this.isValid = false;
        this.previousSlice = -1;
        this.DisplayOffset = myData.DisplayOffset;
        switch (this.myDim) {
            case 0: {
                this.SliceSizeX = myData.Sizes[2];
                this.SliceSizeY = myData.Sizes[1];
                this.AllSize = this.SliceSizeX * this.SliceSizeY;
                this.mySlice = new int[this.AllSize];
                break;
            }
            case 1: {
                this.SliceSizeX = myData.Sizes[0];
                this.SliceSizeY = myData.Sizes[2];
                this.AllSize = this.SliceSizeX * this.SliceSizeY;
                this.mySlice = new int[this.AllSize];
                break;
            }
            case 2: {
                this.SliceSizeX = myData.Sizes[0];
                this.SliceSizeY = myData.Sizes[1];
                this.AllSize = this.SliceSizeX * this.SliceSizeY;
                this.mySlice = new int[this.AllSize];
            }
        }
        this.AllSize = this.SliceSizeX * this.SliceSizeY;
    }

    void TakeModel(ColorModel newModel) {
        this.MyColorModel = newModel;
    }

    void Invalidate() {
        this.isValid = false;
        this.ROISum = Double.NaN;
        this.ROIAvg = Double.NaN;
        this.ROIMax = Double.NaN;
        this.ROIMin = Double.NaN;
        this.ROIVoxels = Double.NaN;
    }

    void setMIPMode(boolean mipmode) {
        if (mipmode != this.MIPMode) {
            this.Invalidate();
        }
        this.MIPMode = mipmode;
    }

    Image GenImage(Container applet) {
        MemoryImageSource ms;
        try {
            ms = new MemoryImageSource(this.SliceSizeX, this.SliceSizeY, this.MyColorModel, this.mySlice, 0, this.SliceSizeX);
        }
        catch (Exception e) {
            System.out.println("Caught Image generation Exception:" + e + "\n");
            e.printStackTrace();
            ms = null;
        }
        return applet.createImage(ms);
    }

    Image GenColorImage(Container applet) {
        MemoryImageSource ms;
        try {
            ms = new MemoryImageSource(this.SliceSizeX, this.SliceSizeY, this.mySlice, 0, this.SliceSizeX);
        }
        catch (Exception e) {
            System.out.println("Caught Image generation Exception:" + e + "\n");
            e.printStackTrace();
            ms = null;
        }
        return applet.createImage(ms);
    }

    void UpdateSlice(int sliceNr, AnElement myData, AnElement GateElement) {
        if (this.previousSlice != sliceNr) {
            this.isValid = false;
        }
        if (this.isValid) {
            return;
        }
        try {
            switch (this.myDim) {
                case 0: {
                    for (int z = 0; z < myData.Sizes[2]; ++z) {
                        for (int y = 0; y < myData.Sizes[1]; ++y) {
                            int val = myData.GetIntValueAt(sliceNr, y, z);
                            if (val < 0) {
                                val = 0;
                            }
                            if (val > Short.MAX_VALUE) {
                                val = Short.MAX_VALUE;
                            }
                            if (GateElement.GetIntValueAt(sliceNr, y, z) <= 0) {
                                val = 0;
                            }
                            this.mySlice[z + myData.Sizes[2] * y] = val;
                        }
                    }
                    break;
                }
                case 1: {
                    for (int z = 0; z < myData.Sizes[2]; ++z) {
                        for (int x = 0; x < myData.Sizes[0]; ++x) {
                            int val = myData.GetIntValueAt(x, sliceNr, z);
                            if (val < 0) {
                                val = 0;
                            }
                            if (val > Short.MAX_VALUE) {
                                val = Short.MAX_VALUE;
                            }
                            if (GateElement.GetIntValueAt(x, sliceNr, z) <= 0) {
                                val = 0;
                            }
                            this.mySlice[x + myData.Sizes[0] * z] = val;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int y = 0; y < myData.Sizes[1]; ++y) {
                        for (int x = 0; x < myData.Sizes[0]; ++x) {
                            int val = myData.GetIntValueAt(x, y, sliceNr);
                            if (val < 0) {
                                val = 0;
                            }
                            if (val > Short.MAX_VALUE) {
                                val = Short.MAX_VALUE;
                            }
                            if (GateElement.GetIntValueAt(x, y, sliceNr) <= 0) {
                                val = 0;
                            }
                            this.mySlice[x + myData.Sizes[0] * y] = val;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught Slice-Copy Exception:" + e + "\n");
            e.printStackTrace();
        }
        this.isValid = true;
        this.previousSlice = sliceNr;
    }

    void SumToColorSlice(int sliceNr, AnElement myData, byte[] CMapR, byte[] CMapG, byte[] CMapB, AnElement GateElement, AnElement ActiveElement) {
        int OffsetX = -((int)(myData.DisplayOffset[0] - ActiveElement.DisplayOffset[0]));
        int OffsetY = -((int)(myData.DisplayOffset[1] - ActiveElement.DisplayOffset[1]));
        int OffsetZ = -((int)(myData.DisplayOffset[2] - ActiveElement.DisplayOffset[2]));
        int GOffsetX = -((int)(GateElement.DisplayOffset[0] - ActiveElement.DisplayOffset[0]));
        int GOffsetY = -((int)(GateElement.DisplayOffset[1] - ActiveElement.DisplayOffset[1]));
        int GOffsetZ = -((int)(GateElement.DisplayOffset[2] - ActiveElement.DisplayOffset[2]));
        try {
            switch (this.myDim) {
                case 0: {
                    for (int z = 0; z < myData.Sizes[2]; ++z) {
                        for (int y = 0; y < myData.Sizes[1]; ++y) {
                            int val;
                            if (myData.WithinBounds(sliceNr + OffsetX, y + OffsetY, z + OffsetZ)) {
                                val = myData.GetIntValueAt(sliceNr + OffsetX, y + OffsetY, z + OffsetZ);
                                if (val < 0) {
                                    val = 0;
                                }
                                if (val > Short.MAX_VALUE) {
                                    val = Short.MAX_VALUE;
                                }
                                if (GateElement.WithinBounds(sliceNr + GOffsetX, y + GOffsetY, z + GOffsetZ)) {
                                    if (GateElement.GetIntValueAt(sliceNr + GOffsetX, y + GOffsetY, z + GOffsetZ) <= 0) {
                                        val = 0;
                                    }
                                } else {
                                    val = 0;
                                }
                            } else {
                                val = 0;
                            }
                            int col = this.mySlice[z + myData.Sizes[2] * y];
                            int Red = CMapR[val] & 0xFF;
                            int Green = CMapG[val] & 0xFF;
                            int Blue = CMapB[val] & 0xFF;
                            if ((Red = (Red << 16) + (col & 0xFF0000)) > 0xFF0000) {
                                Red = 0xFF0000;
                            }
                            if ((Green = (Green << 8) + (col & 0xFF00)) > 65280) {
                                Green = 65280;
                            }
                            if ((Blue += col & 0xFF) > 255) {
                                Blue = 255;
                            }
                            this.mySlice[z + myData.Sizes[2] * y] = 0xFF000000 | Red | Green | Blue;
                        }
                    }
                    break;
                }
                case 1: {
                    for (int z = 0; z < myData.Sizes[2]; ++z) {
                        for (int x = 0; x < myData.Sizes[0]; ++x) {
                            int val;
                            if (myData.WithinBounds(x + OffsetX, sliceNr + OffsetY, z + OffsetZ)) {
                                val = myData.GetIntValueAt(x + OffsetX, sliceNr + OffsetY, z + OffsetZ);
                                if (val < 0) {
                                    val = 0;
                                }
                                if (val > Short.MAX_VALUE) {
                                    val = Short.MAX_VALUE;
                                }
                                if (GateElement.WithinBounds(x + GOffsetX, sliceNr + GOffsetY, z + GOffsetZ)) {
                                    if (GateElement.GetIntValueAt(x + GOffsetX, sliceNr + GOffsetY, z + GOffsetZ) <= 0) {
                                        val = 0;
                                    }
                                } else {
                                    val = 0;
                                }
                            } else {
                                val = 0;
                            }
                            int col = this.mySlice[x + myData.Sizes[0] * z];
                            int Red = CMapR[val] & 0xFF;
                            int Green = CMapG[val] & 0xFF;
                            int Blue = CMapB[val] & 0xFF;
                            if ((Red = (Red << 16) + (col & 0xFF0000)) > 0xFF0000) {
                                Red = 0xFF0000;
                            }
                            if ((Green = (Green << 8) + (col & 0xFF00)) > 65280) {
                                Green = 65280;
                            }
                            if ((Blue += col & 0xFF) > 255) {
                                Blue = 255;
                            }
                            this.mySlice[x + myData.Sizes[0] * z] = 0xFF000000 | Red | Green | Blue;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int y = 0; y < myData.Sizes[1]; ++y) {
                        for (int x = 0; x < myData.Sizes[0]; ++x) {
                            int val;
                            if (myData.WithinBounds(x + OffsetX, y + OffsetY, sliceNr + OffsetZ)) {
                                val = myData.GetIntValueAt(x + OffsetX, y + OffsetY, sliceNr + OffsetZ);
                                if (val < 0) {
                                    val = 0;
                                }
                                if (val > Short.MAX_VALUE) {
                                    val = Short.MAX_VALUE;
                                }
                                if (GateElement.WithinBounds(x + GOffsetX, y + GOffsetY, sliceNr + GOffsetZ)) {
                                    if (GateElement.GetIntValueAt(x + GOffsetX, y + GOffsetY, sliceNr + GOffsetZ) <= 0) {
                                        val = 0;
                                    }
                                } else {
                                    val = 0;
                                }
                            } else {
                                val = 0;
                            }
                            int col = this.mySlice[x + myData.Sizes[0] * y];
                            int Red = CMapR[val] & 0xFF;
                            int Green = CMapG[val] & 0xFF;
                            int Blue = CMapB[val] & 0xFF;
                            if ((Red = (Red << 16) + (col & 0xFF0000)) > 0xFF0000) {
                                Red = 0xFF0000;
                            }
                            if ((Green = (Green << 8) + (col & 0xFF00)) > 65280) {
                                Green = 65280;
                            }
                            if ((Blue += col & 0xFF) > 255) {
                                Blue = 255;
                            }
                            this.mySlice[x + myData.Sizes[0] * y] = 0xFF000000 | Red | Green | Blue;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught Slice-Copy Exception:" + e + "\n");
            e.printStackTrace();
        }
        this.previousSlice = sliceNr;
    }

    void MulToColorSlice(int sliceNr, AnElement myData, byte[] CMapR, byte[] CMapG, byte[] CMapB, AnElement GateElement, AnElement ActiveElement) {
        int OffsetX = -((int)(myData.DisplayOffset[0] - ActiveElement.DisplayOffset[0]));
        int OffsetY = -((int)(myData.DisplayOffset[1] - ActiveElement.DisplayOffset[1]));
        int OffsetZ = -((int)(myData.DisplayOffset[2] - ActiveElement.DisplayOffset[2]));
        int GOffsetX = -((int)(GateElement.DisplayOffset[0] - ActiveElement.DisplayOffset[0]));
        int GOffsetY = -((int)(GateElement.DisplayOffset[1] - ActiveElement.DisplayOffset[1]));
        int GOffsetZ = -((int)(GateElement.DisplayOffset[2] - ActiveElement.DisplayOffset[2]));
        try {
            switch (this.myDim) {
                case 0: {
                    for (int z = 0; z < myData.Sizes[2]; ++z) {
                        for (int y = 0; y < myData.Sizes[1]; ++y) {
                            int val;
                            if (myData.WithinBounds(sliceNr + OffsetX, y + OffsetY, z + OffsetZ)) {
                                val = myData.GetIntValueAt(sliceNr + OffsetX, y + OffsetY, z + OffsetZ);
                                if (val < 0) {
                                    val = 0;
                                }
                                if (val > Short.MAX_VALUE) {
                                    val = Short.MAX_VALUE;
                                }
                                if (GateElement.WithinBounds(sliceNr + GOffsetX, y + GOffsetY, z + GOffsetZ)) {
                                    if (GateElement.GetIntValueAt(sliceNr + GOffsetX, y + GOffsetY, z + GOffsetZ) <= 0) {
                                        val = 0;
                                    }
                                } else {
                                    val = 0;
                                }
                            } else {
                                val = 0;
                            }
                            int col = this.mySlice[z + myData.Sizes[2] * y];
                            int Red = (CMapR[val] & 0xFF) * (col >> 16 & 0xFF);
                            int Green = (CMapG[val] & 0xFF) * (col >> 8 & 0xFF);
                            int Blue = (CMapB[val] & 0xFF) * (col & 0xFF);
                            Red = (Red >> 8 & 0xFF) << 16;
                            Blue = Blue >> 8 & 0xFF;
                            this.mySlice[z + myData.Sizes[2] * y] = 0xFF000000 | Red | (Green &= 0xFF00) | Blue;
                        }
                    }
                    break;
                }
                case 1: {
                    for (int z = 0; z < myData.Sizes[2]; ++z) {
                        for (int x = 0; x < myData.Sizes[0]; ++x) {
                            int val;
                            if (myData.WithinBounds(x + OffsetX, sliceNr + OffsetY, z + OffsetZ)) {
                                val = myData.GetIntValueAt(x + OffsetX, sliceNr + OffsetY, z + OffsetZ);
                                if (val < 0) {
                                    val = 0;
                                }
                                if (val > Short.MAX_VALUE) {
                                    val = Short.MAX_VALUE;
                                }
                                if (GateElement.WithinBounds(x + GOffsetX, sliceNr + GOffsetY, z + GOffsetZ)) {
                                    if (GateElement.GetIntValueAt(x + GOffsetX, sliceNr + GOffsetY, z + GOffsetZ) <= 0) {
                                        val = 0;
                                    }
                                } else {
                                    val = 0;
                                }
                            } else {
                                val = 0;
                            }
                            int col = this.mySlice[x + myData.Sizes[0] * z];
                            int Red = (CMapR[val] & 0xFF) * (col >> 16 & 0xFF);
                            int Green = (CMapG[val] & 0xFF) * (col >> 8 & 0xFF);
                            int Blue = (CMapB[val] & 0xFF) * (col & 0xFF);
                            Red = (Red >> 8 & 0xFF) << 16;
                            Blue = Blue >> 8 & 0xFF;
                            this.mySlice[x + myData.Sizes[0] * z] = 0xFF000000 | Red | (Green &= 0xFF00) | Blue;
                        }
                    }
                    break;
                }
                case 2: {
                    for (int y = 0; y < myData.Sizes[1]; ++y) {
                        for (int x = 0; x < myData.Sizes[0]; ++x) {
                            int val;
                            if (myData.WithinBounds(x + OffsetX, y + OffsetY, sliceNr + OffsetZ)) {
                                val = myData.GetIntValueAt(x + OffsetX, y + OffsetY, sliceNr + OffsetZ);
                                if (val < 0) {
                                    val = 0;
                                }
                                if (val > Short.MAX_VALUE) {
                                    val = Short.MAX_VALUE;
                                }
                                if (GateElement.WithinBounds(x + GOffsetX, y + GOffsetY, sliceNr + GOffsetZ)) {
                                    if (GateElement.GetIntValueAt(x + GOffsetX, y + GOffsetY, sliceNr + GOffsetZ) <= 0) {
                                        val = 0;
                                    }
                                } else {
                                    val = 0;
                                }
                            } else {
                                val = 0;
                            }
                            int col = this.mySlice[x + myData.Sizes[0] * y];
                            int Red = (CMapR[val] & 0xFF) * (col >> 16 & 0xFF);
                            int Green = (CMapG[val] & 0xFF) * (col >> 8 & 0xFF);
                            int Blue = (CMapB[val] & 0xFF) * (col & 0xFF);
                            Red = (Red >> 8 & 0xFF) << 16;
                            Blue = Blue >> 8 & 0xFF;
                            this.mySlice[x + myData.Sizes[0] * y] = 0xFF000000 | Red | (Green &= 0xFF00) | Blue;
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught Slice-Copy Exception:" + e + "\n");
            e.printStackTrace();
        }
        this.previousSlice = sliceNr;
    }

    void MulToColorSlice(ASlice myData, byte[] CMapR, byte[] CMapG, byte[] CMapB, ASlice GateSlice, boolean GateActive, AnElement ActiveElement) {
        int XDim = 0;
        int YDim = 1;
        switch (this.myDim) {
            case 0: {
                XDim = 1;
                YDim = 2;
                break;
            }
            case 1: {
                XDim = 0;
                YDim = 2;
                break;
            }
            case 2: {
                XDim = 0;
                YDim = 1;
            }
        }
        int OffsetX = -((int)(myData.DisplayOffset[XDim] - ActiveElement.DisplayOffset[XDim]));
        int OffsetY = -((int)(myData.DisplayOffset[YDim] - ActiveElement.DisplayOffset[YDim]));
        int GOffsetX = -((int)(GateSlice.DisplayOffset[XDim] - ActiveElement.DisplayOffset[XDim]));
        int GOffsetY = -((int)(GateSlice.DisplayOffset[YDim] - ActiveElement.DisplayOffset[YDim]));
        try {
            for (int y = 0; y < myData.SliceSizeY; ++y) {
                for (int x = 0; x < myData.SliceSizeX; ++x) {
                    int val;
                    if (myData.WithinBounds(x + OffsetX, y + OffsetY)) {
                        val = myData.GetIntValueAt(x + OffsetX, y + OffsetY);
                        if (val < 0) {
                            val = 0;
                        }
                        if (val > Short.MAX_VALUE) {
                            val = Short.MAX_VALUE;
                        }
                        if (GateActive) {
                            if (GateSlice.WithinBounds(x + GOffsetX, y + GOffsetY)) {
                                if (GateSlice.GetIntValueAt(x + GOffsetX, y + GOffsetY) <= 0) {
                                    val = 0;
                                }
                            } else {
                                val = 0;
                            }
                        }
                    } else {
                        val = 0;
                    }
                    if (val < 0) {
                        val = 0;
                    }
                    if (val > Short.MAX_VALUE) {
                        val = Short.MAX_VALUE;
                    }
                    if (GateActive && GateSlice.GetIntValueAt(x, y) <= 0) {
                        val = 0;
                    }
                    int col = this.mySlice[x + myData.SliceSizeX * y];
                    int Red = (CMapR[val] & 0xFF) * (col >> 16 & 0xFF);
                    int Green = (CMapG[val] & 0xFF) * (col >> 8 & 0xFF);
                    int Blue = (CMapB[val] & 0xFF) * (col & 0xFF);
                    Red = (Red >> 8 & 0xFF) << 16;
                    Blue = Blue >> 8 & 0xFF;
                    this.mySlice[x + myData.SliceSizeX * y] = 0xFF000000 | Red | (Green &= 0xFF00) | Blue;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught Slice-Copy Exception:" + e + "\n");
            e.printStackTrace();
        }
    }

    void SumToColorSlice(ASlice myData, byte[] CMapR, byte[] CMapG, byte[] CMapB, ASlice GateSlice, boolean GateActive, AnElement ActiveElement) {
        int XDim = 0;
        int YDim = 1;
        switch (this.myDim) {
            case 0: {
                XDim = 1;
                YDim = 2;
                break;
            }
            case 1: {
                XDim = 0;
                YDim = 2;
                break;
            }
            case 2: {
                XDim = 0;
                YDim = 1;
            }
        }
        int OffsetX = -((int)(myData.DisplayOffset[XDim] - ActiveElement.DisplayOffset[XDim]));
        int OffsetY = -((int)(myData.DisplayOffset[YDim] - ActiveElement.DisplayOffset[YDim]));
        int GOffsetX = -((int)(GateSlice.DisplayOffset[XDim] - ActiveElement.DisplayOffset[XDim]));
        int GOffsetY = -((int)(GateSlice.DisplayOffset[YDim] - ActiveElement.DisplayOffset[YDim]));
        try {
            for (int y = 0; y < myData.SliceSizeY; ++y) {
                for (int x = 0; x < myData.SliceSizeX; ++x) {
                    int val;
                    if (myData.WithinBounds(x + OffsetX, y + OffsetY)) {
                        val = myData.GetIntValueAt(x + OffsetX, y + OffsetY);
                        if (val < 0) {
                            val = 0;
                        }
                        if (val > Short.MAX_VALUE) {
                            val = Short.MAX_VALUE;
                        }
                        if (GateActive) {
                            if (GateSlice.WithinBounds(x + GOffsetX, y + GOffsetY)) {
                                if (GateSlice.GetIntValueAt(x + GOffsetX, y + GOffsetY) <= 0) {
                                    val = 0;
                                }
                            } else {
                                val = 0;
                            }
                        }
                    } else {
                        val = 0;
                    }
                    int col = this.mySlice[x + myData.SliceSizeX * y];
                    int Red = CMapR[val] & 0xFF;
                    int Green = CMapG[val] & 0xFF;
                    int Blue = CMapB[val] & 0xFF;
                    if ((Red = (Red << 16) + (col & 0xFF0000)) > 0xFF0000) {
                        Red = 0xFF0000;
                    }
                    if ((Green = (Green << 8) + (col & 0xFF00)) > 65280) {
                        Green = 65280;
                    }
                    if ((Blue += col & 0xFF) > 255) {
                        Blue = 255;
                    }
                    this.mySlice[x + myData.SliceSizeX * y] = 0xFF000000 | Red | Green | Blue;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Caught Slice-Copy Exception:" + e + "\n");
            e.printStackTrace();
        }
    }

    boolean WithinBounds(int x, int y) {
        if (x >= this.SliceSizeX) {
            return false;
        }
        if (y >= this.SliceSizeY) {
            return false;
        }
        if (x < 0) {
            return false;
        }
        return y >= 0;
    }

    int GetIntValueAt(int x, int y) {
        return this.mySlice[x + this.SliceSizeX * y];
    }

    void MergeColor(int color, ASlice Slice) {
        int shift = 0;
        shift = color == 0 ? 16 : (color == 1 ? 8 : 0);
        int i = 0;
        while (i < this.AllSize) {
            int val = Slice.mySlice[i] >> 8;
            int n = i++;
            this.mySlice[n] = this.mySlice[n] | val << shift;
        }
    }

    public void ClearColor() {
        for (int i = 0; i < this.AllSize; ++i) {
            this.mySlice[i] = -16777216;
        }
    }

    public void Clear() {
        for (int i = 0; i < this.AllSize; ++i) {
            this.mySlice[i] = 0;
        }
    }

    private int ProjSizeDim(int projdim) {
        if (projdim == 0) {
            return 1;
        }
        if (projdim == 2) {
            return 2;
        }
        if (projdim == 1) {
            return 0;
        }
        return 2;
    }

    private int Proj1DPos(int projdim, int x, int y, int z) {
        if (projdim == 0) {
            return y;
        }
        if (projdim == 2) {
            return z;
        }
        if (projdim == 1) {
            return x;
        }
        return z;
    }

    private int XPos3D(int pdir, int px, int py, int pos) {
        if (pdir == 0) {
            return pos;
        }
        if (pdir == 1) {
            return px;
        }
        return px;
    }

    private int YPos3D(int pdir, int px, int py, int pos) {
        if (pdir == 0) {
            return py;
        }
        if (pdir == 1) {
            return pos;
        }
        return py;
    }

    private int ZPos3D(int pdir, int px, int py, int pos) {
        if (pdir == 0) {
            return px;
        }
        if (pdir == 1) {
            return py;
        }
        return pos;
    }

    public void DoProject(int direction, AnElement myData, AnElement gate, ROI roi) {
        int voxels = 0;
        int maxVal = 0;
        int pvoxels = 0;
        this.ROISum = 0.0;
        this.ROIAvg = 0.0;
        this.ROIMax = -1.7976931348623157E308;
        this.ROIMin = Double.MAX_VALUE;
        int Proj1DSize = myData.Sizes[this.ProjSizeDim(direction)];
        if (this.my1DProj == null) {
            this.my1DProj = new double[Proj1DSize];
            this.my1DProjVoxels = new int[Proj1DSize];
        }
        this.Clear();
        for (int i = 0; i < Proj1DSize; ++i) {
            this.my1DProj[i] = 0.0;
            this.my1DProjVoxels[i] = 0;
        }
        for (int px = 0; px < this.SliceSizeX; ++px) {
            for (int py = 0; py < this.SliceSizeY; ++py) {
                pvoxels = 0;
                for (int pos = 0; pos < myData.Sizes[direction]; ++pos) {
                    int val;
                    int x = this.XPos3D(direction, px, py, pos) + (int)myData.DisplayOffset[0];
                    int xo = x - (int)myData.DisplayOffset[0];
                    int y = this.YPos3D(direction, px, py, pos) + (int)myData.DisplayOffset[1];
                    int yo = y - (int)myData.DisplayOffset[1];
                    int z = this.ZPos3D(direction, px, py, pos) + (int)myData.DisplayOffset[2];
                    int zo = z - (int)myData.DisplayOffset[2];
                    int gx = this.XPos3D(direction, px, py, pos) + (int)gate.DisplayOffset[0];
                    int gy = this.YPos3D(direction, px, py, pos) + (int)gate.DisplayOffset[1];
                    int gz = this.ZPos3D(direction, px, py, pos) + (int)gate.DisplayOffset[2];
                    if (!myData.WithinBounds(xo, yo, zo) || !gate.WithinBounds(gx, gy, gz) || !roi.InROIRange(x, y, z) || gate.GetIntValueAt(gx, gy, gz) <= 0) continue;
                    ++voxels;
                    ++pvoxels;
                    double rval = myData.GetValueAt(xo, yo, zo);
                    this.ROISum += rval;
                    if (rval < this.ROIMin) {
                        this.ROIMin = rval;
                    }
                    if (rval > this.ROIMax) {
                        this.ROIMax = rval;
                    }
                    if ((val = myData.GetIntValueAt(xo, yo, zo)) < 0) {
                        val = 0;
                    }
                    int n = this.Proj1DPos(direction, x, y, z);
                    this.my1DProjVoxels[n] = this.my1DProjVoxels[n] + 1;
                    if (this.MIPMode) {
                        if (val > this.mySlice[px + this.SliceSizeX * py]) {
                            this.mySlice[px + this.SliceSizeX * py] = val;
                        }
                        if (!(rval > this.my1DProj[this.Proj1DPos(direction, x, y, z)])) continue;
                        this.my1DProj[this.Proj1DPos((int)direction, (int)x, (int)y, (int)z)] = rval;
                        continue;
                    }
                    int n2 = px + this.SliceSizeX * py;
                    this.mySlice[n2] = this.mySlice[n2] + val;
                    int n3 = this.Proj1DPos(direction, x, y, z);
                    this.my1DProj[n3] = this.my1DProj[n3] + rval;
                }
                if (pvoxels <= 0) continue;
                if (!this.MIPMode) {
                    int n = px + this.SliceSizeX * py;
                    this.mySlice[n] = this.mySlice[n] / pvoxels;
                }
                if (this.mySlice[px + this.SliceSizeX * py] <= maxVal) continue;
                maxVal = this.mySlice[px + this.SliceSizeX * py];
            }
        }
        double scale = 32767.0 / (double)maxVal;
        for (int i = 0; i < this.AllSize; ++i) {
            this.mySlice[i] = (int)((double)this.mySlice[i] * scale);
            if (this.mySlice[i] >= 0) continue;
            this.mySlice[i] = 0;
        }
        double maxVal1D = -1.0E30;
        double minVal1D = 1.0E30;
        for (int i = 0; i < Proj1DSize; ++i) {
            if (!this.MIPMode && this.my1DProjVoxels[i] > 0) {
                int n = i;
                this.my1DProj[n] = this.my1DProj[n] / (double)this.my1DProjVoxels[i];
            }
            if (this.my1DProj[i] > maxVal1D) {
                maxVal1D = this.my1DProj[i];
            }
            if (!(this.my1DProj[i] < minVal1D)) continue;
            minVal1D = this.my1DProj[i];
        }
        this.Proj1DScale = 1.0 / (maxVal1D - minVal1D);
        this.Proj1DOffset = minVal1D;
        if (voxels > 0) {
            this.ROIAvg = this.ROISum / (double)voxels;
        }
        this.ROIVoxels = voxels;
        this.isValid = true;
    }

    double Get1DProjValue(int pos) {
        if (pos < 0) {
            pos = 0;
        }
        if (pos >= this.SliceSizeX * this.SliceSizeY) {
            pos = this.SliceSizeX * this.SliceSizeY - 1;
        }
        if (this.my1DProj != null) {
            return this.my1DProj[pos];
        }
        System.out.println("Error: Projection not initialized\n");
        return 0.0;
    }

    double GetNormed1DProjValue(int pos) {
        if (pos < 0) {
            pos = 0;
        }
        if (pos >= this.SliceSizeX * this.SliceSizeY) {
            pos = this.SliceSizeX * this.SliceSizeY - 1;
        }
        if (this.my1DProj != null) {
            return (this.my1DProj[pos] - this.Proj1DOffset) * this.Proj1DScale;
        }
        System.out.println("Error: Projection not initialized\n");
        return 0.0;
    }

    public ImagePlus Export() {
        ImagePlus myim = NewImage.createShortImage((String)"View5D Gray Slice", (int)this.SliceSizeX, (int)this.SliceSizeY, (int)1, (int)1);
        short[] pix = (short[])myim.getImageStack().getPixels(1);
        for (int i = 0; i < this.SliceSizeX * this.SliceSizeY; ++i) {
            pix[i] = (short)this.mySlice[i];
        }
        return myim;
    }

    public ImagePlus ColorExport() {
        ImagePlus myim = NewImage.createRGBImage((String)"View5D Color Slice", (int)this.SliceSizeX, (int)this.SliceSizeY, (int)1, (int)1);
        int[] pix = (int[])myim.getImageStack().getPixels(1);
        for (int i = 0; i < this.SliceSizeX * this.SliceSizeY; ++i) {
            pix[i] = this.mySlice[i];
        }
        return myim;
    }
}

