/*
 * Decompiled with CFR 0.152.
 */
package graphcut;

import graphcut.Graph;
import graphcut.Terminal;
import java.util.LinkedList;
import java.util.List;

public class GraphCut {
    private Graph graph;
    private int edgeNum;
    private float totalFlow;
    private int maxflowIteration;
    private int[] activeQueueFirst;
    private int[] activeQueueLast;
    private LinkedList<Integer> orphans;
    private int time;

    public GraphCut(int numNodes, int numEdges) {
        this.graph = new Graph(numNodes, numEdges);
        this.edgeNum = 0;
        this.totalFlow = 0.0f;
        this.maxflowIteration = 0;
        this.activeQueueFirst = new int[2];
        this.activeQueueLast = new int[2];
        this.orphans = new LinkedList();
    }

    public void setTerminalWeights(int node, float source, float sink) {
        float delta = this.graph.getResidualNodeCapacity(node);
        if (delta > 0.0f) {
            source += delta;
        } else {
            sink -= delta;
        }
        this.totalFlow += source < sink ? source : sink;
        this.graph.setResidualNodeCapacity(node, source - sink);
    }

    public void setEdgeWeight(int node1, int node2, float weight) {
        this.setEdgeWeight(node1, node2, weight, weight);
    }

    public void setEdgeWeight(int node1, int node2, float weight1to2, float weight2to1) {
        int edge = this.edgeNum++;
        int reverseEdge = this.edgeNum++;
        this.graph.setSister(edge, reverseEdge);
        this.graph.setSister(reverseEdge, edge);
        this.graph.setNextEdge(edge, this.graph.getFirstOutgoing(node1));
        this.graph.setFirstOutgoing(node1, edge);
        this.graph.setNextEdge(reverseEdge, this.graph.getFirstOutgoing(node2));
        this.graph.setFirstOutgoing(node2, reverseEdge);
        this.graph.setHead(edge, node2);
        this.graph.setHead(reverseEdge, node1);
        this.graph.setResidualEdgeCapacity(edge, weight1to2);
        this.graph.setResidualEdgeCapacity(reverseEdge, weight2to1);
    }

    public float computeMaximumFlow(boolean reuseTrees, List<Integer> changedNodes) {
        if (this.maxflowIteration == 0) {
            reuseTrees = false;
        }
        if (reuseTrees) {
            this.maxflowReuseTreesInit();
        } else {
            this.maxflowInit();
        }
        int currentNode = -1;
        int edge = -1;
        block0: while (true) {
            int headNode;
            int activeNode;
            if ((activeNode = currentNode) != -1) {
                this.graph.setNextNode(activeNode, -1);
                if (this.graph.getParent(activeNode) == -1) {
                    activeNode = -1;
                }
            }
            if (activeNode == -1 && (activeNode = this.getNextActiveNode()) == -1) break;
            if (!this.graph.isInSink(activeNode)) {
                edge = this.graph.getFirstOutgoing(activeNode);
                while (edge != -1) {
                    if (this.graph.getResidualEdgeCapacity(edge) != 0.0f) {
                        headNode = this.graph.getHead(edge);
                        if (this.graph.getParent(headNode) == -1) {
                            this.graph.isInSink(headNode, false);
                            this.graph.setParent(headNode, this.graph.getSister(edge));
                            this.graph.setTimestamp(headNode, this.graph.getTimestamp(activeNode));
                            this.graph.setDistance(headNode, this.graph.getDistance(activeNode) + 1);
                            this.setNodeActive(headNode);
                            this.addToChangedList(headNode);
                        } else {
                            if (this.graph.isInSink(headNode)) break;
                            if (this.graph.getTimestamp(headNode) <= this.graph.getTimestamp(activeNode) && this.graph.getDistance(headNode) > this.graph.getDistance(activeNode)) {
                                this.graph.setParent(headNode, this.graph.getSister(edge));
                                this.graph.setTimestamp(headNode, this.graph.getTimestamp(activeNode));
                                this.graph.setDistance(headNode, this.graph.getDistance(activeNode) + 1);
                            }
                        }
                    }
                    edge = this.graph.getNextEdge(edge);
                }
            } else {
                edge = this.graph.getFirstOutgoing(activeNode);
                while (edge != -1) {
                    if (this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) != 0.0f) {
                        headNode = this.graph.getHead(edge);
                        if (this.graph.getParent(headNode) == -1) {
                            this.graph.isInSink(headNode, true);
                            this.graph.setParent(headNode, this.graph.getSister(edge));
                            this.graph.setTimestamp(headNode, this.graph.getTimestamp(activeNode));
                            this.graph.setDistance(headNode, this.graph.getDistance(activeNode) + 1);
                            this.setNodeActive(headNode);
                            this.addToChangedList(headNode);
                        } else {
                            if (!this.graph.isInSink(headNode)) {
                                edge = this.graph.getSister(edge);
                                break;
                            }
                            if (this.graph.getTimestamp(headNode) <= this.graph.getTimestamp(activeNode) && this.graph.getDistance(headNode) > this.graph.getDistance(activeNode)) {
                                this.graph.setParent(headNode, this.graph.getSister(edge));
                                this.graph.setTimestamp(headNode, this.graph.getTimestamp(activeNode));
                                this.graph.setDistance(headNode, this.graph.getDistance(activeNode) + 1);
                            }
                        }
                    }
                    edge = this.graph.getNextEdge(edge);
                }
            }
            ++this.time;
            if (edge != -1) {
                this.graph.setNextNode(activeNode, activeNode);
                currentNode = activeNode;
                this.augment(edge);
                while (true) {
                    if (this.orphans.size() <= 0) continue block0;
                    int orphan = this.orphans.poll();
                    if (this.graph.isInSink(orphan)) {
                        this.processSinkOrphan(orphan);
                        continue;
                    }
                    this.processSourceOrphan(orphan);
                }
            }
            currentNode = -1;
        }
        ++this.maxflowIteration;
        if (changedNodes != null) {
            changedNodes.clear();
            for (int i = 0; i < this.graph.getNumNodes(); ++i) {
                if (!this.graph.isInChangedList(i)) continue;
                changedNodes.add(i);
            }
        }
        return this.totalFlow;
    }

    public Terminal getTerminal(int node) {
        if (this.graph.getParent(node) != -1) {
            return this.graph.isInSink(node) ? Terminal.BACKGROUND : Terminal.FOREGROUND;
        }
        return Terminal.BACKGROUND;
    }

    public int getNumNodes() {
        return this.graph.getNumNodes();
    }

    public int getNumEdges() {
        return this.graph.getNumEdges();
    }

    public void markNode(int node) {
        if (this.graph.getNextNode(node) == -1) {
            if (this.activeQueueLast[1] != -1) {
                this.graph.setNextNode(this.activeQueueLast[1], node);
            } else {
                this.activeQueueFirst[1] = node;
            }
            this.activeQueueLast[1] = node;
            this.graph.setNextNode(node, node);
        }
        this.graph.isMarked(node, true);
    }

    private void setNodeActive(int node) {
        if (this.graph.getNextNode(node) == -1) {
            if (this.activeQueueLast[1] != -1) {
                this.graph.setNextNode(this.activeQueueLast[1], node);
            } else {
                this.activeQueueFirst[1] = node;
            }
            this.activeQueueLast[1] = node;
            this.graph.setNextNode(node, node);
        }
    }

    private int getNextActiveNode() {
        int node;
        do {
            if ((node = this.activeQueueFirst[0]) == -1) {
                node = this.activeQueueFirst[1];
                this.activeQueueFirst[0] = this.activeQueueFirst[1];
                this.activeQueueLast[0] = this.activeQueueLast[1];
                this.activeQueueFirst[1] = -1;
                this.activeQueueLast[1] = -1;
                if (node == -1) {
                    return -1;
                }
            }
            if (this.graph.getNextNode(node) == node) {
                this.activeQueueFirst[0] = -1;
                this.activeQueueLast[0] = -1;
            } else {
                this.activeQueueFirst[0] = this.graph.getNextNode(node);
            }
            this.graph.setNextNode(node, -1);
        } while (this.graph.getParent(node) == -1);
        return node;
    }

    private void addOrphanAtFront(int node) {
        this.graph.setParent(node, -3);
        this.orphans.addFirst(node);
    }

    private void addOrphanAtBack(int node) {
        this.graph.setParent(node, -3);
        this.orphans.addLast(node);
    }

    private void addToChangedList(int node) {
        this.graph.isInChangedList(node, true);
    }

    private void maxflowInit() {
        this.activeQueueFirst[0] = -1;
        this.activeQueueLast[0] = -1;
        this.activeQueueFirst[1] = -1;
        this.activeQueueLast[1] = -1;
        this.orphans.clear();
        this.time = 0;
        for (int node = 0; node < this.graph.getNumNodes(); ++node) {
            this.graph.setNextNode(node, -1);
            this.graph.isMarked(node, false);
            this.graph.isInChangedList(node, false);
            this.graph.setTimestamp(node, this.time);
            if (this.graph.getResidualNodeCapacity(node) > 0.0f) {
                this.graph.isInSink(node, false);
                this.graph.setParent(node, -2);
                this.setNodeActive(node);
                this.graph.setDistance(node, 1);
                continue;
            }
            if (this.graph.getResidualNodeCapacity(node) < 0.0f) {
                this.graph.isInSink(node, true);
                this.graph.setParent(node, -2);
                this.setNodeActive(node);
                this.graph.setDistance(node, 1);
                continue;
            }
            this.graph.setParent(node, -1);
        }
    }

    private void maxflowReuseTreesInit() {
        int node1;
        int queueStart = this.activeQueueFirst[1];
        this.activeQueueFirst[0] = -1;
        this.activeQueueLast[0] = -1;
        this.activeQueueFirst[1] = -1;
        this.activeQueueLast[1] = -1;
        this.orphans.clear();
        ++this.time;
        while ((node1 = queueStart) != -1) {
            int node2;
            int edge;
            queueStart = this.graph.getNextNode(node1);
            if (queueStart == node1) {
                queueStart = -1;
            }
            this.graph.setNextNode(node1, -1);
            this.graph.isMarked(node1, false);
            this.setNodeActive(node1);
            if (this.graph.getResidualNodeCapacity(node1) == 0.0f) {
                if (this.graph.getParent(node1) == -1) continue;
                this.addOrphanAtBack(node1);
                continue;
            }
            if (this.graph.getResidualNodeCapacity(node1) > 0.0f) {
                if (this.graph.getParent(node1) == -1 || this.graph.isInSink(node1)) {
                    this.graph.isInSink(node1, false);
                    edge = this.graph.getFirstOutgoing(node1);
                    while (edge != -1) {
                        node2 = this.graph.getHead(edge);
                        if (!this.graph.isMarked(node2)) {
                            if (this.graph.getParent(node2) == this.graph.getSister(edge)) {
                                this.addOrphanAtBack(node2);
                            }
                            if (this.graph.getParent(node2) != -1 && this.graph.isInSink(node2) && this.graph.getResidualEdgeCapacity(edge) > 0.0f) {
                                this.setNodeActive(node2);
                            }
                        }
                        edge = this.graph.getNextEdge(edge);
                    }
                    this.addToChangedList(node1);
                }
            } else if (this.graph.getParent(node1) == -1 || !this.graph.isInSink(node1)) {
                this.graph.isInSink(node1, true);
                edge = this.graph.getFirstOutgoing(node1);
                while (edge != -1) {
                    node2 = this.graph.getHead(edge);
                    if (!this.graph.isMarked(node2)) {
                        if (this.graph.getParent(node2) == this.graph.getSister(edge)) {
                            this.addOrphanAtBack(node2);
                        }
                        if (this.graph.getParent(node2) != -1 && !this.graph.isInSink(node2) && this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) > 0.0f) {
                            this.setNodeActive(node2);
                        }
                    }
                    edge = this.graph.getNextEdge(edge);
                }
                this.addToChangedList(node1);
            }
            this.graph.setParent(node1, -2);
            this.graph.setTimestamp(node1, this.time);
            this.graph.setDistance(node1, 1);
        }
        while (this.orphans.size() > 0) {
            int orphan = this.orphans.poll();
            if (this.graph.isInSink(orphan)) {
                this.processSinkOrphan(orphan);
                continue;
            }
            this.processSourceOrphan(orphan);
        }
    }

    private void augment(int middle) {
        int edge;
        float bottleneck = this.graph.getResidualEdgeCapacity(middle);
        int node = this.graph.getHead(this.graph.getSister(middle));
        while ((edge = this.graph.getParent(node)) != -2) {
            if (bottleneck > this.graph.getResidualEdgeCapacity(this.graph.getSister(edge))) {
                bottleneck = this.graph.getResidualEdgeCapacity(this.graph.getSister(edge));
            }
            node = this.graph.getHead(edge);
        }
        if (bottleneck > this.graph.getResidualNodeCapacity(node)) {
            bottleneck = this.graph.getResidualNodeCapacity(node);
        }
        node = this.graph.getHead(middle);
        while ((edge = this.graph.getParent(node)) != -2) {
            if (bottleneck > this.graph.getResidualEdgeCapacity(edge)) {
                bottleneck = this.graph.getResidualEdgeCapacity(edge);
            }
            node = this.graph.getHead(edge);
        }
        if (bottleneck > -this.graph.getResidualNodeCapacity(node)) {
            bottleneck = -this.graph.getResidualNodeCapacity(node);
        }
        this.graph.setResidualEdgeCapacity(this.graph.getSister(middle), this.graph.getResidualEdgeCapacity(this.graph.getSister(middle)) + bottleneck);
        this.graph.setResidualEdgeCapacity(middle, this.graph.getResidualEdgeCapacity(middle) - bottleneck);
        node = this.graph.getHead(this.graph.getSister(middle));
        while ((edge = this.graph.getParent(node)) != -2) {
            this.graph.setResidualEdgeCapacity(edge, this.graph.getResidualEdgeCapacity(edge) + bottleneck);
            this.graph.setResidualEdgeCapacity(this.graph.getSister(edge), this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) - bottleneck);
            if (this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) == 0.0f) {
                this.addOrphanAtFront(node);
            }
            node = this.graph.getHead(edge);
        }
        this.graph.setResidualNodeCapacity(node, this.graph.getResidualNodeCapacity(node) - bottleneck);
        if (this.graph.getResidualNodeCapacity(node) == 0.0f) {
            this.addOrphanAtFront(node);
        }
        node = this.graph.getHead(middle);
        while ((edge = this.graph.getParent(node)) != -2) {
            this.graph.setResidualEdgeCapacity(this.graph.getSister(edge), this.graph.getResidualEdgeCapacity(this.graph.getSister(edge)) + bottleneck);
            this.graph.setResidualEdgeCapacity(edge, this.graph.getResidualEdgeCapacity(edge) - bottleneck);
            if (this.graph.getResidualEdgeCapacity(edge) == 0.0f) {
                this.addOrphanAtFront(node);
            }
            node = this.graph.getHead(edge);
        }
        this.graph.setResidualNodeCapacity(node, this.graph.getResidualNodeCapacity(node) + bottleneck);
        if (this.graph.getResidualNodeCapacity(node) == 0.0f) {
            this.addOrphanAtFront(node);
        }
        this.totalFlow += bottleneck;
    }

    private void processSourceOrphan(int orphan) {
        int parentEdge;
        int node;
        int bestEdge = -1;
        int minDistance = Integer.MAX_VALUE;
        int orphanEdge = this.graph.getFirstOutgoing(orphan);
        while (orphanEdge != -1) {
            if (this.graph.getResidualEdgeCapacity(this.graph.getSister(orphanEdge)) != 0.0f) {
                node = this.graph.getHead(orphanEdge);
                parentEdge = this.graph.getParent(node);
                if (!this.graph.isInSink(node) && parentEdge != -1) {
                    int distance = 0;
                    while (true) {
                        if (this.graph.getTimestamp(node) == this.time) {
                            distance += this.graph.getDistance(node);
                            break;
                        }
                        parentEdge = this.graph.getParent(node);
                        ++distance;
                        if (parentEdge == -2) {
                            this.graph.setTimestamp(node, this.time);
                            this.graph.setDistance(node, 1);
                            break;
                        }
                        if (parentEdge == -3) {
                            distance = Integer.MAX_VALUE;
                            break;
                        }
                        node = this.graph.getHead(parentEdge);
                    }
                    if (distance < Integer.MAX_VALUE) {
                        if (distance < minDistance) {
                            bestEdge = orphanEdge;
                            minDistance = distance;
                        }
                        node = this.graph.getHead(orphanEdge);
                        while (this.graph.getTimestamp(node) != this.time) {
                            this.graph.setTimestamp(node, this.time);
                            this.graph.setDistance(node, distance);
                            --distance;
                            node = this.graph.getHead(this.graph.getParent(node));
                        }
                    }
                }
            }
            orphanEdge = this.graph.getNextEdge(orphanEdge);
        }
        this.graph.setParent(orphan, bestEdge);
        if (bestEdge != -1) {
            this.graph.setTimestamp(orphan, this.time);
            this.graph.setDistance(orphan, minDistance + 1);
        } else {
            this.addToChangedList(orphan);
            orphanEdge = this.graph.getFirstOutgoing(orphan);
            while (orphanEdge != -1) {
                node = this.graph.getHead(orphanEdge);
                parentEdge = this.graph.getParent(node);
                if (!this.graph.isInSink(node) && parentEdge != -1) {
                    if (this.graph.getResidualEdgeCapacity(this.graph.getSister(orphanEdge)) != 0.0f) {
                        this.setNodeActive(node);
                    }
                    if (parentEdge != -2 && parentEdge != -3 && this.graph.getHead(parentEdge) == orphan) {
                        this.addOrphanAtBack(node);
                    }
                }
                orphanEdge = this.graph.getNextEdge(orphanEdge);
            }
        }
    }

    private void processSinkOrphan(int orphan) {
        int parentEdge;
        int node;
        int bestEdge = -1;
        int minDistance = Integer.MAX_VALUE;
        int orphanEdge = this.graph.getFirstOutgoing(orphan);
        while (orphanEdge != -1) {
            if (this.graph.getResidualEdgeCapacity(orphanEdge) != 0.0f) {
                node = this.graph.getHead(orphanEdge);
                parentEdge = this.graph.getParent(node);
                if (this.graph.isInSink(node) && parentEdge != -1) {
                    int distance = 0;
                    while (true) {
                        if (this.graph.getTimestamp(node) == this.time) {
                            distance += this.graph.getDistance(node);
                            break;
                        }
                        parentEdge = this.graph.getParent(node);
                        ++distance;
                        if (parentEdge == -2) {
                            this.graph.setTimestamp(node, this.time);
                            this.graph.setDistance(node, 1);
                            break;
                        }
                        if (parentEdge == -3) {
                            distance = Integer.MAX_VALUE;
                            break;
                        }
                        node = this.graph.getHead(parentEdge);
                    }
                    if (distance < Integer.MAX_VALUE) {
                        if (distance < minDistance) {
                            bestEdge = orphanEdge;
                            minDistance = distance;
                        }
                        node = this.graph.getHead(orphanEdge);
                        while (this.graph.getTimestamp(node) != this.time) {
                            this.graph.setTimestamp(node, this.time);
                            this.graph.setDistance(node, distance);
                            --distance;
                            node = this.graph.getHead(this.graph.getParent(node));
                        }
                    }
                }
            }
            orphanEdge = this.graph.getNextEdge(orphanEdge);
        }
        this.graph.setParent(orphan, bestEdge);
        if (bestEdge != -1) {
            this.graph.setTimestamp(orphan, this.time);
            this.graph.setDistance(orphan, minDistance + 1);
        } else {
            this.addToChangedList(orphan);
            orphanEdge = this.graph.getFirstOutgoing(orphan);
            while (orphanEdge != -1) {
                node = this.graph.getHead(orphanEdge);
                parentEdge = this.graph.getParent(node);
                if (this.graph.isInSink(node) && parentEdge != -1) {
                    if (this.graph.getResidualEdgeCapacity(orphanEdge) != 0.0f) {
                        this.setNodeActive(node);
                    }
                    if (parentEdge != -2 && parentEdge != -3 && this.graph.getHead(parentEdge) == orphan) {
                        this.addOrphanAtBack(node);
                    }
                }
                orphanEdge = this.graph.getNextEdge(orphanEdge);
            }
        }
    }
}

