/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser;

import java.awt.Font;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.drjekyll.fontchooser.FontFamiliesFactory;
import org.drjekyll.fontchooser.FontFamily;

public class FontFamilies
implements Iterable<FontFamily> {
    private static final FontFamilies INSTANCE = FontFamilies.createFontFamilies();
    private final Map<String, FontFamily> families = new TreeMap<String, FontFamily>();

    private static FontFamilies createFontFamilies() {
        return FontFamiliesFactory.create();
    }

    public static FontFamilies getInstance() {
        return INSTANCE;
    }

    public void add(Font font) {
        String family = font.getFamily();
        FontFamily fontFamily = this.families.computeIfAbsent(family, FontFamily::new);
        fontFamily.add(font);
    }

    @Override
    public Iterator<FontFamily> iterator() {
        return this.families.values().iterator();
    }

    public FontFamily get(String name) {
        return this.families.get(name);
    }
}

