/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import java.io.File;
import java.io.IOException;
import org.apposed.appose.Builder;

public interface BuildHandler {
    public boolean channel(String var1, String var2);

    public boolean include(String var1, String var2);

    public String envName();

    public void build(File var1, Builder var2) throws IOException;

    default public void progress(Builder builder, String title, long current) {
        this.progress(builder, title, current, -1L);
    }

    default public void progress(Builder builder, String title, long current, long maximum) {
        builder.progressSubscribers.forEach(subscriber -> subscriber.accept(title, current, maximum));
    }

    default public void output(Builder builder, String message) {
        builder.outputSubscribers.forEach(subscriber -> subscriber.accept(message));
    }

    default public void error(Builder builder, String message) {
        builder.errorSubscribers.forEach(subscriber -> subscriber.accept(message));
    }
}

