/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import com.sun.jna.Pointer;
import com.sun.jna.platform.linux.LibRT;
import com.sun.jna.platform.win32.Kernel32;
import groovy.json.JsonOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.groovy.util.ScriptRunner;
import org.apache.ivy.Ivy;
import org.apposed.appose.FilePaths;
import org.apposed.appose.GroovyWorker;
import org.apposed.appose.Service;

public interface Environment {
    public String base();

    public List<String> binPaths();

    public List<String> classpath();

    public List<String> launchArgs();

    default public Service python() throws IOException {
        List<String> pythonExes = Arrays.asList("python", "python3", "python.exe");
        return this.service(pythonExes, "-c", "import appose.python_worker; appose.python_worker.main()");
    }

    default public Service groovy(String ... jvmArgs) throws IOException {
        return this.groovy(Collections.emptyList(), jvmArgs);
    }

    default public Service groovy(List<String> classPath, String ... jvmArgs) throws IOException {
        return this.java(GroovyWorker.class.getName(), classPath, jvmArgs);
    }

    default public Service java(String mainClass, String ... jvmArgs) throws IOException {
        return this.java(mainClass, Collections.emptyList(), jvmArgs);
    }

    default public Service java(String mainClass, List<String> classPath, String ... jvmArgs) throws IOException {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        List<Class> apposeDeps = Arrays.asList(GroovyWorker.class, ScriptRunner.class, JsonOutput.class, Ivy.class, Pointer.class, LibRT.class, Kernel32.class, ArchiveException.class);
        for (Class depClass : apposeDeps) {
            File location = FilePaths.location(depClass);
            if (location == null) continue;
            cp.add(location.getCanonicalPath());
        }
        cp.addAll(classPath);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-cp");
        args.add(String.join((CharSequence)File.pathSeparator, cp));
        args.addAll(Arrays.asList(jvmArgs));
        args.add(mainClass);
        List<String> javaExes = Arrays.asList("java", "java.exe", "bin/java", "bin/java.exe", "jre/bin/java", "jre/bin/java.exe");
        return this.service(javaExes, args.toArray(new String[0]));
    }

    default public Service service(List<String> exes, String ... args) throws IOException {
        String exe;
        if (exes == null || exes.isEmpty()) {
            throw new IllegalArgumentException("No executable given");
        }
        File exeFile = FilePaths.findExe(this.binPaths(), exes);
        List<String> launchArgs = this.launchArgs();
        if (exeFile == null) {
            if (launchArgs.isEmpty()) {
                throw new IllegalArgumentException("No executables found amongst candidates: " + exes);
            }
            exe = exes.get(0);
        } else {
            exe = exeFile.getCanonicalPath();
        }
        ArrayList<String> allArgs = new ArrayList<String>(launchArgs);
        allArgs.add(exe);
        allArgs.addAll(Arrays.asList(args));
        return new Service(new File(this.base()), allArgs.toArray(new String[0]));
    }
}

