/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public final class FilePaths {
    private FilePaths() {
    }

    public static File location(Class<?> c) {
        try {
            return new File(c.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException exc) {
            return null;
        }
    }

    public static File findExe(List<String> dirs, List<String> exes) {
        for (String exe : exes) {
            File exeFile = new File(exe);
            if (exeFile.isAbsolute()) {
                if (!exeFile.canExecute()) continue;
                return exeFile;
            }
            for (String dir : dirs) {
                File f = Paths.get(dir, exe).toFile();
                if (!f.canExecute() || f.isDirectory()) continue;
                return f;
            }
        }
        return null;
    }

    public static void moveDirectory(File srcDir, File destDir, boolean overwrite) throws IOException {
        if (!srcDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + srcDir);
        }
        if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + destDir);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(srcDir.toPath());){
            for (Path srcPath : stream) {
                FilePaths.moveFile(srcPath.toFile(), destDir, overwrite);
            }
        }
        if (!srcDir.delete()) {
            throw new IOException("Could not remove directory " + destDir);
        }
    }

    public static void moveFile(File srcFile, File destDir, boolean overwrite) throws IOException {
        File destFile = new File(destDir, srcFile.getName());
        if (srcFile.isDirectory()) {
            if (!destFile.exists() && !destFile.mkdirs()) {
                throw new IOException("Failed to create destination directory: " + destDir);
            }
            FilePaths.moveDirectory(srcFile, destFile, overwrite);
            return;
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IllegalArgumentException("Non-directory destination path: " + destDir);
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException("Failed to create destination directory: " + destDir);
        }
        if (destFile.exists() && !overwrite) {
            FilePaths.renameToBackup(srcFile, destDir);
            return;
        }
        FilePaths.renameToBackup(destFile);
        if (!srcFile.renameTo(destFile)) {
            throw new IOException("Failed to move file: " + srcFile + " -> " + destFile);
        }
    }

    public static void renameToBackup(File srcFile) throws IOException {
        FilePaths.renameToBackup(srcFile, srcFile.getParentFile());
    }

    public static void renameToBackup(File srcFile, File destDir) throws IOException {
        if (!srcFile.exists()) {
            return;
        }
        String prefix = srcFile.getName();
        String suffix = "old";
        File backupFile = new File(destDir, prefix + "." + suffix);
        for (int i = 0; i < 1000 && backupFile.exists(); ++i) {
            backupFile = new File(destDir, prefix + "." + i + "." + suffix);
        }
        if (backupFile.exists()) {
            File failedTarget = new File(destDir, prefix + "." + suffix);
            throw new UnsupportedOperationException("Too many backup files already exist for target: " + failedTarget);
        }
        if (!srcFile.renameTo(backupFile)) {
            throw new IOException("Failed to rename file:" + srcFile + " -> " + backupFile);
        }
    }
}

