/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apposed.appose.TaskEvent;
import org.apposed.appose.Types;

public class Service
implements AutoCloseable {
    private static int serviceCount = 0;
    private final File cwd;
    private final String[] args;
    private final Map<String, Task> tasks = new ConcurrentHashMap<String, Task>();
    private final int serviceID;
    private final List<String> invalidLines = new ArrayList<String>();
    private final List<String> errorLines = new ArrayList<String>();
    private Process process;
    private PrintWriter stdin;
    private Thread stdoutThread;
    private Thread stderrThread;
    private Thread monitorThread;
    private Consumer<String> debugListener;

    public Service(File cwd, String ... args) {
        this.cwd = cwd;
        this.args = (String[])args.clone();
        this.serviceID = serviceCount++;
    }

    public void debug(Consumer<String> debugListener) {
        this.debugListener = debugListener;
    }

    public Service start() throws IOException {
        if (this.process != null) {
            return this;
        }
        String prefix = "Appose-Service-" + this.serviceID;
        ProcessBuilder pb = new ProcessBuilder(this.args).directory(this.cwd);
        this.process = pb.start();
        this.stdin = new PrintWriter(this.process.getOutputStream());
        this.stdoutThread = new Thread(this::stdoutLoop, prefix + "-Stdout");
        this.stderrThread = new Thread(this::stderrLoop, prefix + "-Stderr");
        this.monitorThread = new Thread(this::monitorLoop, prefix + "-Monitor");
        this.stderrThread.start();
        this.stdoutThread.start();
        this.monitorThread.start();
        return this;
    }

    public Task task(String script) throws IOException {
        return this.task(script, null);
    }

    public Task task(String script, Map<String, Object> inputs) throws IOException {
        this.start();
        return new Task(script, inputs);
    }

    @Override
    public void close() {
        this.stdin.close();
    }

    public void kill() {
        this.process.destroyForcibly();
    }

    public int waitFor() throws InterruptedException {
        this.process.waitFor();
        this.stdoutThread.join();
        this.stderrThread.join();
        this.monitorThread.join();
        return this.process.exitValue();
    }

    public boolean isAlive() {
        return this.process != null && this.process.isAlive();
    }

    public List<String> invalidLines() {
        return Collections.unmodifiableList(this.invalidLines);
    }

    public List<String> errorLines() {
        return Collections.unmodifiableList(this.errorLines);
    }

    private void stdoutLoop() {
        BufferedReader stdout = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        while (true) {
            String line;
            try {
                line = stdout.readLine();
            }
            catch (IOException exc) {
                this.debugService(Types.stackTrace(exc));
                break;
            }
            if (line == null) {
                this.debugService("<worker stdout closed>");
                break;
            }
            try {
                Map<String, Object> response = Types.decode(line);
                this.debugService(line);
                Object uuid = response.get("task");
                if (uuid == null) {
                    this.debugService("Invalid service message:" + line);
                    continue;
                }
                Task task = this.tasks.get(uuid.toString());
                if (task == null) {
                    this.debugService("No such task: " + uuid);
                    continue;
                }
                task.handle(response);
            }
            catch (Exception exc) {
                this.debugService(String.format("<INVALID> %s", line));
                this.invalidLines.add(line);
            }
        }
    }

    private void stderrLoop() {
        BufferedReader stderr = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        while (true) {
            String line;
            try {
                line = stderr.readLine();
            }
            catch (IOException exc) {
                this.debugService(Types.stackTrace(exc));
                break;
            }
            if (line == null) {
                this.debugService("<worker stderr closed>");
                break;
            }
            this.debugWorker(line);
            this.errorLines.add(line);
        }
    }

    private void monitorLoop() {
        Collection<Task> remainingTasks;
        int taskCount;
        while (this.process.isAlive() || this.stdoutThread.isAlive() || this.stderrThread.isAlive()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException exc) {
                this.debugService(Types.stackTrace(exc));
            }
        }
        this.debugService("<worker process termination detected>");
        int exitCode = this.process.exitValue();
        if (exitCode != 0) {
            this.debugService("<worker process terminated with exit code " + exitCode + ">");
        }
        if ((taskCount = this.tasks.size()) > 0) {
            this.debugService("<worker process terminated with " + taskCount + " pending task" + (taskCount == 1 ? "" : "s") + ">");
        }
        if (!(remainingTasks = this.tasks.values()).isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String nl = System.lineSeparator();
            sb.append("Worker crashed with exit code ").append(exitCode).append(".").append(nl);
            String stdout = this.invalidLines.isEmpty() ? "<none>" : String.join((CharSequence)nl, this.invalidLines);
            String stderr = this.errorLines.isEmpty() ? "<none>" : String.join((CharSequence)nl, this.errorLines);
            sb.append(nl).append("[stdout]").append(nl).append(stdout).append(nl);
            sb.append(nl).append("[stderr]").append(nl).append(stderr).append(nl);
            String error = sb.toString();
            remainingTasks.forEach(task -> ((Task)task).crash(error));
        }
        this.tasks.clear();
    }

    private void debugService(String message) {
        this.debug("SERVICE", message);
    }

    private void debugWorker(String message) {
        this.debug("WORKER", message);
    }

    private void debug(String prefix, String message) {
        if (this.debugListener == null) {
            return;
        }
        this.debugListener.accept("[" + prefix + "-" + this.serviceID + "] " + message);
    }

    public class Task {
        public final String uuid = UUID.randomUUID().toString();
        public final String script;
        private final Map<String, Object> mInputs = new HashMap<String, Object>();
        private final Map<String, Object> mOutputs = new HashMap<String, Object>();
        public final Map<String, Object> inputs = Collections.unmodifiableMap(this.mInputs);
        public final Map<String, Object> outputs = Collections.unmodifiableMap(this.mOutputs);
        public TaskStatus status = TaskStatus.INITIAL;
        public String message;
        public long current;
        public long maximum = 1L;
        public String error;
        private final List<Consumer<TaskEvent>> listeners = new ArrayList<Consumer<TaskEvent>>();

        public Task(String script, Map<String, Object> inputs) {
            this.script = script;
            if (inputs != null) {
                this.mInputs.putAll(inputs);
            }
            Service.this.tasks.put(this.uuid, this);
        }

        public synchronized Task start() {
            if (this.status != TaskStatus.INITIAL) {
                throw new IllegalStateException();
            }
            this.status = TaskStatus.QUEUED;
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("script", this.script);
            args.put("inputs", this.inputs);
            this.request(RequestType.EXECUTE, args);
            return this;
        }

        public synchronized void listen(Consumer<TaskEvent> listener) {
            if (this.status != TaskStatus.INITIAL) {
                throw new IllegalStateException("Task is not in the INITIAL state");
            }
            this.listeners.add(listener);
        }

        public synchronized void waitFor() throws InterruptedException {
            if (this.status == TaskStatus.INITIAL) {
                this.start();
            }
            if (this.status != TaskStatus.QUEUED && this.status != TaskStatus.RUNNING) {
                return;
            }
            this.wait();
        }

        public void cancel() {
            this.request(RequestType.CANCEL, null);
        }

        private void request(RequestType requestType, Map<String, Object> args) {
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("task", this.uuid);
            request.put("requestType", requestType.toString());
            if (args != null) {
                request.putAll(args);
            }
            String encoded = Types.encode(request);
            Service.this.stdin.println(encoded);
            Service.this.stdin.flush();
            Service.this.debugService(encoded);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle(Map<String, Object> response) {
            String maybeResponseType = (String)response.get("responseType");
            if (maybeResponseType == null) {
                Service.this.debugService("Message type not specified");
                return;
            }
            ResponseType responseType = ResponseType.valueOf(maybeResponseType);
            switch (responseType) {
                case LAUNCH: {
                    this.status = TaskStatus.RUNNING;
                    break;
                }
                case UPDATE: {
                    this.message = (String)response.get("message");
                    Number current = (Number)response.get("current");
                    Number maximum = (Number)response.get("maximum");
                    if (current != null) {
                        this.current = current.longValue();
                    }
                    if (maximum == null) break;
                    this.maximum = maximum.longValue();
                    break;
                }
                case COMPLETION: {
                    Service.this.tasks.remove(this.uuid);
                    this.status = TaskStatus.COMPLETE;
                    Map outputs = (Map)response.get("outputs");
                    if (outputs == null) break;
                    this.mOutputs.putAll(outputs);
                    break;
                }
                case CANCELATION: {
                    Service.this.tasks.remove(this.uuid);
                    this.status = TaskStatus.CANCELED;
                    break;
                }
                case FAILURE: {
                    Service.this.tasks.remove(this.uuid);
                    this.status = TaskStatus.FAILED;
                    Object error = response.get("error");
                    this.error = error == null ? null : error.toString();
                    break;
                }
                default: {
                    Service.this.debugService("Invalid service message type: " + (Object)((Object)responseType));
                    return;
                }
            }
            TaskEvent event = new TaskEvent(this, responseType);
            this.listeners.forEach(l -> l.accept(event));
            if (this.status.isFinished()) {
                Task task = this;
                synchronized (task) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void crash(String error) {
            TaskEvent event = new TaskEvent(this, ResponseType.CRASH);
            this.status = TaskStatus.CRASHED;
            this.error = error;
            this.listeners.forEach(l -> l.accept(event));
            Task task = this;
            synchronized (task) {
                this.notifyAll();
            }
        }

        public String toString() {
            return String.format("uuid=%s, status=%s, message=%s, current=%d, maximum=%d, error=%s", new Object[]{this.uuid, this.status, this.message, this.current, this.maximum, this.error});
        }
    }

    public static enum ResponseType {
        LAUNCH,
        UPDATE,
        COMPLETION,
        CANCELATION,
        FAILURE,
        CRASH;

    }

    public static enum RequestType {
        EXECUTE,
        CANCEL;

    }

    public static enum TaskStatus {
        INITIAL,
        QUEUED,
        RUNNING,
        COMPLETE,
        CANCELED,
        FAILED,
        CRASHED;


        public boolean isFinished() {
            return this == COMPLETE || this == CANCELED || this == FAILED || this == CRASHED;
        }
    }
}

