/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import com.sun.jna.Pointer;
import java.util.ServiceLoader;
import org.apposed.appose.ShmFactory;

public interface SharedMemory
extends AutoCloseable {
    public static SharedMemory create(String name, int size) {
        return SharedMemory.createOrAttach(name, true, size);
    }

    public static SharedMemory attach(String name, int size) {
        return SharedMemory.createOrAttach(name, false, size);
    }

    public static SharedMemory createOrAttach(String name, boolean create, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("'size' must be a positive integer");
        }
        if (create && size == 0) {
            throw new IllegalArgumentException("'size' must be a positive number different from zero");
        }
        if (!create && name == null) {
            throw new IllegalArgumentException("'name' can only be null if create=true");
        }
        ServiceLoader<ShmFactory> loader = ServiceLoader.load(ShmFactory.class);
        for (ShmFactory factory : loader) {
            SharedMemory shm = factory.create(name, create, size);
            if (shm == null) continue;
            return shm;
        }
        throw new UnsupportedOperationException("No SharedMemory support for this platform");
    }

    public String name();

    public int size();

    public Pointer pointer();

    public void unlinkOnClose(boolean var1);

    public void unlink();

    @Override
    public void close();

    public String toString();
}

