/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import groovy.json.JsonGenerator;
import groovy.json.JsonSlurper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apposed.appose.NDArray;
import org.apposed.appose.SharedMemory;

public final class Types {
    static final JsonGenerator GENERATOR = new JsonGenerator.Options().addConverter(Types.convert(SharedMemory.class, "shm", (map, shm) -> {
        map.put("name", shm.name());
        map.put("size", shm.size());
    })).addConverter(Types.convert(NDArray.class, "ndarray", (map, ndArray) -> {
        map.put("dtype", ndArray.dType().label());
        map.put("shape", ndArray.shape().toIntArray(NDArray.Shape.Order.C_ORDER));
        map.put("shm", ndArray.shm());
    })).build();

    private Types() {
    }

    public static String encode(Map<?, ?> data) {
        return GENERATOR.toJson(data);
    }

    public static Map<String, Object> decode(String json) {
        return Types.postProcess(new JsonSlurper().parseText(json));
    }

    public static String stackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private static <T> JsonGenerator.Converter convert(final Class<T> clz, final String appose_type, final BiConsumer<Map<String, Object>, T> converter) {
        return new JsonGenerator.Converter(){

            public boolean handles(Class<?> type) {
                return clz.isAssignableFrom(type);
            }

            public Object convert(Object value, String key) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("appose_type", appose_type);
                converter.accept(map, value);
                return map;
            }
        };
    }

    private static Map<String, Object> postProcess(Object parseResult) {
        return Types.processMap((Map)parseResult);
    }

    private static Map<String, Object> processMap(Map<String, Object> map) {
        map.entrySet().forEach(entry -> entry.setValue(Types.processValue(entry.getValue())));
        return map;
    }

    private static Object processValue(Object value) {
        if (value instanceof Map) {
            Map<String, Object> map = Types.processMap((Map)value);
            Object v = map.get("appose_type");
            if (v instanceof String) {
                String appose_type;
                switch (appose_type = (String)v) {
                    case "shm": {
                        String name = (String)map.get("name");
                        int size = (Integer)map.get("size");
                        return SharedMemory.attach(name, size);
                    }
                    case "ndarray": {
                        NDArray.DType dType = Types.toDType((String)map.get("dtype"));
                        NDArray.Shape shape = Types.toShape((List)map.get("shape"));
                        SharedMemory shm = (SharedMemory)map.get("shm");
                        return new NDArray(dType, shape, shm);
                    }
                }
                System.err.println("unknown appose_type \"" + appose_type + "\"");
            }
            return map;
        }
        return value;
    }

    private static NDArray.DType toDType(String dtype) {
        return NDArray.DType.fromLabel(dtype);
    }

    private static NDArray.Shape toShape(List<Integer> shape) {
        int[] ints = new int[shape.size()];
        Arrays.setAll(ints, shape::get);
        return new NDArray.Shape(NDArray.Shape.Order.C_ORDER, ints);
    }
}

