/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.mamba;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.apposed.appose.BuildHandler;
import org.apposed.appose.Builder;
import org.apposed.appose.FilePaths;
import org.apposed.appose.mamba.Mamba;

public class MambaHandler
implements BuildHandler {
    private final List<String> channels = new ArrayList<String>();
    private final List<String> condaIncludes = new ArrayList<String>();
    private final List<String> yamlIncludes = new ArrayList<String>();
    private final List<String> pypiIncludes = new ArrayList<String>();

    @Override
    public boolean channel(String name, String location) {
        if (location == null) {
            this.channels.add(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean include(String content, String scheme) {
        if (content == null) {
            throw new NullPointerException("content must not be null");
        }
        if (scheme == null) {
            throw new NullPointerException("scheme must not be null");
        }
        switch (scheme) {
            case "conda": {
                this.condaIncludes.addAll(this.lines(content));
                return true;
            }
            case "pypi": {
                this.pypiIncludes.addAll(this.lines(content));
                return true;
            }
            case "environment.yml": {
                this.yamlIncludes.add(content);
                return true;
            }
        }
        return false;
    }

    @Override
    public String envName() {
        for (String yaml : this.yamlIncludes) {
            String[] lines = yaml.split("(\r\n|\n|\r)");
            Optional<String> name = Arrays.stream(lines).filter(line -> line.startsWith("name:")).map(line -> line.substring(5).trim().replace("\"", "")).findFirst();
            if (!name.isPresent()) continue;
            return name.get();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void build(File envDir, Builder builder) throws IOException {
        if (!(this.channels.isEmpty() && this.condaIncludes.isEmpty() && this.pypiIncludes.isEmpty())) {
            throw new UnsupportedOperationException("Sorry, I don't know how to mix in additional packages from Conda or PyPI yet. Please put them in your environment.yml for now.");
        }
        Mamba conda = new Mamba(Mamba.BASE_PATH);
        boolean isCondaDir = new File(envDir, "conda-meta").isDirectory();
        if (this.yamlIncludes.isEmpty()) {
            if (!isCondaDir) return;
            this.fillConfig(conda, envDir, builder.config);
            return;
        }
        if (this.yamlIncludes.size() > 1) {
            throw new UnsupportedOperationException("Sorry, I can't synthesize Conda environments from multiple environment.yml files yet. Please use a single environment.yml for now.");
        }
        if (isCondaDir) {
            this.fillConfig(conda, envDir, builder.config);
            return;
        }
        Path envPath = envDir.getAbsoluteFile().toPath();
        String antiCollision = "" + (new Random().nextInt(90000000) + 10000000);
        File workDir = envPath.resolveSibling(envPath.getFileName() + "." + antiCollision + ".tmp").toFile();
        if (envDir.exists()) {
            if (!envDir.isDirectory()) throw new IllegalArgumentException("Non-directory file already exists: " + envDir.getAbsolutePath());
            if (!envDir.renameTo(workDir)) {
                throw new IOException("Failed to rename directory: " + envDir + " -> " + workDir);
            }
        } else if (!workDir.mkdirs()) {
            throw new IOException("Failed to create work directory: " + workDir);
        }
        File environmentYaml = new File(workDir, "environment.yml");
        FilePaths.renameToBackup(environmentYaml);
        try (FileWriter fout = new FileWriter(environmentYaml);){
            fout.write(this.yamlIncludes.get(0));
        }
        try {
            conda.setOutputConsumer(msg -> builder.outputSubscribers.forEach(sub -> sub.accept(msg)));
            conda.setErrorConsumer(msg -> builder.errorSubscribers.forEach(sub -> sub.accept(msg)));
            conda.setMambaDownloadProgressConsumer((cur, max) -> builder.progressSubscribers.forEach(subscriber -> subscriber.accept("Downloading micromamba", (long)cur, (long)max)));
            conda.installMicromamba();
            conda.createWithYaml(envDir, environmentYaml.getAbsolutePath());
            this.fillConfig(conda, envDir, builder.config);
            return;
        }
        catch (InterruptedException | URISyntaxException e) {
            throw new IOException(e);
        }
        finally {
            FilePaths.moveDirectory(workDir, envDir, false);
        }
    }

    private List<String> lines(String content) {
        return Arrays.stream(content.split("(\r\n|\n|\r)")).map(String::trim).filter(s -> !s.isEmpty() && !s.startsWith("#")).collect(Collectors.toList());
    }

    private void fillConfig(Mamba conda, File envDir, Map<String, List<String>> config) {
        config.computeIfAbsent("launchArgs", k -> new ArrayList());
        config.get("launchArgs").addAll(Arrays.asList(conda.mambaCommand, "run", "-p", envDir.getAbsolutePath()));
    }
}

