/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

interface MacosHelpers
extends Library {
    public static final String LIBRARY_NAME = "ShmCreate";
    public static final String LIBRARY_NAME_SUF = ".dylib";
    public static final MacosHelpers INSTANCE = MacosHelpers.loadLibrary();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MacosHelpers loadLibrary() {
        try (InputStream in = MacosHelpers.class.getResourceAsStream("ShmCreate.dylib");){
            File tempFile = File.createTempFile(LIBRARY_NAME, LIBRARY_NAME_SUF);
            tempFile.deleteOnExit();
            Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            MacosHelpers macosHelpers = (MacosHelpers)Native.load((String)tempFile.getAbsolutePath(), MacosHelpers.class);
            return macosHelpers;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int create_shared_memory(String var1, int var2);

    public void unlink_shared_memory(String var1);

    public long get_shared_memory_size(int var1);
}

