/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.apposed.appose.SharedMemory;
import org.apposed.appose.ShmFactory;
import org.apposed.appose.shm.CLibrary;
import org.apposed.appose.shm.LibRt;
import org.apposed.appose.shm.ShmBase;
import org.apposed.appose.shm.ShmUtils;

public class ShmLinux
implements ShmFactory {
    @Override
    public SharedMemory create(String name, boolean create, int size) {
        if (ShmUtils.os != ShmUtils.OS.LINUX) {
            return null;
        }
        return new SharedMemoryLinux(name, create, size);
    }

    private static class SharedMemoryLinux
    extends ShmBase<Integer> {
        private SharedMemoryLinux(String name, boolean create, int size) {
            super(SharedMemoryLinux.prepareShm(name, create, size));
        }

        @Override
        protected void doUnlink() {
            LibRtOrC.shm_unlink(this.name());
        }

        @Override
        protected void doClose() {
            if (this.pointer() != Pointer.NULL && LibRtOrC.munmap(this.pointer(), this.size()) == -1) {
                throw new RuntimeException("munmap failed. Errno: " + Native.getLastError());
            }
            if (LibRtOrC.close((Integer)this.info.handle) == -1) {
                throw new RuntimeException("close failed. Errno: " + Native.getLastError());
            }
        }

        private static ShmBase.ShmInfo<Integer> prepareShm(String name, boolean create, int size) {
            String shm_name;
            long prevSize;
            if (name == null) {
                while ((prevSize = SharedMemoryLinux.getSHMSize(shm_name = ShmUtils.make_filename(14, "/psm_"))) >= 0L) {
                }
            } else {
                shm_name = ShmUtils.withLeadingSlash(name);
                prevSize = SharedMemoryLinux.getSHMSize(shm_name);
            }
            ShmUtils.checkSize(shm_name, prevSize, size);
            int shmFd = LibRtOrC.shm_open(shm_name, ShmUtils.O_CREAT | ShmUtils.O_RDWR, 438);
            if (shmFd < 0) {
                throw new RuntimeException("shm_open failed, errno: " + Native.getLastError());
            }
            if (create && LibRtOrC.ftruncate(shmFd, size) == -1) {
                LibRtOrC.close(shmFd);
                throw new RuntimeException("ftruncate failed, errno: " + Native.getLastError());
            }
            int shm_size = (int)SharedMemoryLinux.getSHMSize(shmFd);
            Pointer pointer = LibRtOrC.mmap(Pointer.NULL, shm_size, ShmUtils.PROT_READ | ShmUtils.PROT_WRITE, ShmUtils.MAP_SHARED, shmFd, 0);
            if (pointer == Pointer.NULL) {
                LibRtOrC.close(shmFd);
                LibRtOrC.shm_unlink(shm_name);
                throw new RuntimeException("mmap failed, errno: " + Native.getLastError());
            }
            ShmBase.ShmInfo<Integer> info = new ShmBase.ShmInfo<Integer>();
            info.size = shm_size;
            info.name = ShmUtils.withoutLeadingSlash(shm_name);
            info.pointer = pointer;
            info.handle = shmFd;
            info.unlinkOnClose = create;
            return info;
        }

        private static long getSHMSize(String name) {
            int shmFd = LibRtOrC.shm_open(name, ShmUtils.O_RDONLY, 448);
            if (shmFd < 0) {
                return -1L;
            }
            return SharedMemoryLinux.getSHMSize(shmFd);
        }

        private static long getSHMSize(int shmFd) {
            if (shmFd < 0) {
                throw new RuntimeException("Invalid shmFd. It should be bigger than 0.");
            }
            long size = LibRtOrC.lseek(shmFd, 0L, 2);
            if (size == -1L) {
                throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Native.getLastError());
            }
            return size;
        }

        private static class LibRtOrC {
            private static boolean useLibRT = true;
            static final int SEEK_SET = 0;
            static final int SEEK_CUR = 1;
            static final int SEEK_END = 2;

            private LibRtOrC() {
            }

            static int shm_open(String name, int oflag, int mode) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.shm_open(name, oflag, mode);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.shm_open(name, oflag, mode);
            }

            static long lseek(int fd, long offset, int whence) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.lseek(fd, offset, whence);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.lseek(fd, offset, whence);
            }

            static int ftruncate(int fd, int length) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.ftruncate(fd, length);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.ftruncate(fd, length);
            }

            static Pointer mmap(Pointer addr, int length, int prot, int flags, int fd, int offset) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.mmap(addr, length, prot, flags, fd, offset);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.mmap(addr, length, prot, flags, fd, offset);
            }

            static int munmap(Pointer addr, int length) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.munmap(addr, length);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.munmap(addr, length);
            }

            static int close(int fd) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.close(fd);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.close(fd);
            }

            static int shm_unlink(String name) {
                if (useLibRT) {
                    try {
                        return LibRt.INSTANCE.shm_unlink(name);
                    }
                    catch (Exception ex) {
                        useLibRT = false;
                    }
                }
                return CLibrary.INSTANCE.shm_unlink(name);
            }
        }
    }
}

