/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import fiji.tool.AbstractTrackingTool;
import fiji.tool.ToolToggleListener;
import fiji.tool.ToolWithOptions;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.RoiDecoder;
import ij.io.RoiEncoder;
import ij.measure.ResultsTable;
import ij.plugin.CanvasResizer;
import ij.plugin.Straightener;
import ij.plugin.frame.RoiManager;
import ij.process.FloatPolygon;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.List;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sc.fiji.timelapse.DummyCanvas;
import sc.fiji.timelapse.KymographMouseListener;
import sc.fiji.timelapse.Peak_Counter_Tool;
import sc.fiji.timelapse.PolygonRoiPublic;
import sc.fiji.timelapse.ProfileStack;

public class LOI_Interpolator_Tool
extends AbstractTrackingTool
implements KeyListener,
ToolToggleListener,
ToolWithOptions,
MouseWheelListener {
    protected int x;
    protected int y;
    protected boolean moving;
    protected boolean constructing;
    protected PolygonRoiPublic roi;

    public LOI_Interpolator_Tool() {
        this.clearToolsIfNecessary = true;
    }

    public String getToolIcon() {
        return "C888D93D84C555Dc4C888D35D75C555Db5C000De5C888L4666C555Db6C000De6C555Da7C000Dd7C555L8898C000Dd8C555L6979C000Dc9C555L3a5aC000DbaL9babL6c8cL3d5d";
    }

    public Roi optimizeRoi(Roi roi, ImageProcessor ip) {
        if (roi instanceof PolygonRoi) {
            return new PolygonRoiPublic((PolygonRoi)roi);
        }
        return null;
    }

    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (this.constructing && e.getClickCount() > 1) {
            this.constructing = false;
            this.x = this.getOffscreenX(e);
            this.y = this.getOffscreenY(e);
            int i = 0;
            while (i < e.getClickCount() && this.activeHandle >= 1 && !(this.roi.distanceToHandle(this.activeHandle, this.x, this.y) > 15.0)) {
                this.roi.deleteHandle(this.activeHandle);
                ++i;
                --this.activeHandle;
            }
            ImagePlus image = this.getImagePlus(e);
            image.setRoi((Roi)this.roi);
            image.updateAndDraw();
            Roi[] rois = this.getRois(image);
            int currentSlice = image.getCurrentSlice();
            this.interpolateFrom(rois, currentSlice);
        }
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
        this.x = this.getOffscreenX(e);
        this.y = this.getOffscreenY(e);
        ImagePlus image = this.getImagePlus(e);
        if (this.updateROI(image)) {
            if (!this.constructing && (e.getModifiersEx() & 0x40) != 0) {
                this.activeHandle = this.roi.insertHandle(this.x, this.y);
            }
            if (this.constructing) {
                this.activeHandle = this.roi.addHandle(this.x, this.y);
            }
            if (this.activeHandle < 0 && this.roi.lineContains(this.x, this.y)) {
                this.moving = true;
                this.getImageCanvas(e).setCursor(DummyCanvas.getMoveCursor());
            } else if (!this.constructing && this.activeHandle >= 0 && (e.getModifiersEx() & 0x200) != 0) {
                this.roi.deleteHandle(this.activeHandle);
                this.roi.specifiedByUser = true;
                this.roi.setImage(image);
                image.setRoi((Roi)this.roi);
                e.consume();
                return;
            }
        } else {
            this.activeHandle = -1;
        }
        if (!this.moving && this.activeHandle < 0) {
            this.roi = new PolygonRoiPublic(new int[]{this.x, this.x}, new int[]{this.y, this.y}, 2, 6);
            this.roi.specifiedByUser = true;
            this.roi.setImage(image);
            image.setRoi((Roi)this.roi);
            this.constructing = true;
            this.activeHandle = 1;
        }
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.roi == null) {
            return;
        }
        if (this.moving) {
            this.moving = false;
            this.getImageCanvas(e).setCursor(DummyCanvas.getDefaultCursor());
        } else {
            this.roi.updatePolygon();
        }
        this.roi.specifiedByUser = true;
        ImagePlus image = this.getImagePlus(e);
        image.setRoi((Roi)this.roi);
        Roi[] rois = this.getRois(image);
        int currentSlice = image.getCurrentSlice();
        rois[currentSlice - 1] = this.roi;
        this.interpolateFrom(rois, currentSlice);
        e.consume();
    }

    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        e.consume();
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        e.consume();
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        ImagePlus image = this.getImagePlus(e);
        if (this.updateROI(image)) {
            if (this.constructing) {
                this.roi.moveHandle(this.activeHandle, this.getOffscreenX(e), this.getOffscreenY(e));
                image.setRoi((Roi)this.roi);
                image.updateAndDraw();
            } else {
                this.activeHandle = this.getHandle((Roi)this.roi, e.getX(), e.getY());
                if (this.activeHandle < 0 && this.roi.lineContains(this.getOffscreenX(e), this.getOffscreenY(e))) {
                    this.getImageCanvas(e).setCursor(DummyCanvas.getMoveCursor());
                }
            }
        } else {
            this.activeHandle = -1;
        }
        e.consume();
    }

    public void mouseDragged(MouseEvent e) {
        ImagePlus image = this.getImagePlus(e);
        if (this.updateROI(image)) {
            if (this.activeHandle >= 0) {
                this.roi.setImage(image);
                this.roi.moveHandle(this.activeHandle, this.getOffscreenX(e), this.getOffscreenY(e));
                image.setRoi((Roi)this.roi);
            } else if (this.moving) {
                this.roi.specifiedByUser = true;
                int deltaX = this.getOffscreenX(e) - this.x;
                int deltaY = this.getOffscreenY(e) - this.y;
                if (deltaX != 0 || deltaY != 0) {
                    this.roi.move(deltaX, deltaY);
                    this.x += deltaX;
                    this.y += deltaY;
                    image.updateAndDraw();
                }
            }
        } else {
            super.mouseDragged(e);
        }
        e.consume();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if ((e.getModifiersEx() & (0x80 | 0x200)) == 128) {
            int newWidth = Line.getWidth() - e.getWheelRotation();
            Line.setWidth((int)newWidth);
            if (this.roi != null) {
                this.roi.updateWideLine(newWidth);
                this.getImagePlus(e).setRoi((Roi)this.roi);
            }
            e.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 75) {
            this.doRegistration(this.getImagePlus(e), (e.getModifiersEx() & 0x40) != 0);
        } else if (keyCode == 69 && (e.getModifiersEx() & 0x40) == 0) {
            this.showStraightenedStack(this.getImagePlus(e));
        } else if (keyCode == 80 && (e.getModifiersEx() & 0x40) != 0) {
            this.showPeaks(this.getImagePlus(e));
        } else if (keyCode == 76 && (e.getModifiersEx() & 0x40) != 0) {
            this.loadROIs(this.getImagePlus(e));
        } else {
            return;
        }
        e.consume();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void sliceChanged(ImagePlus image) {
        super.sliceChanged(image);
    }

    public void showOptionDialog() {
        final GenericDialogPlus gd = new GenericDialogPlus(this.getToolName() + " Options");
        gd.addButton("Show kymograph [k]", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gd.dispose();
                ImagePlus image = LOI_Interpolator_Tool.this.doRegistration(WindowManager.getCurrentImage(), false);
                if (image == null) {
                    IJ.error((String)"Need ellipse ROIs!");
                }
            }
        });
        gd.addButton("Show kymograph & spreadsheet [K]", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gd.dispose();
                ImagePlus image = LOI_Interpolator_Tool.this.doRegistration(WindowManager.getCurrentImage(), true);
                if (image == null) {
                    IJ.error((String)"Need ellipse ROIs!");
                }
            }
        });
        gd.addButton("Export straightened stack [e]", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gd.dispose();
                ImagePlus image = WindowManager.getCurrentImage();
                if (image == null) {
                    IJ.error((String)"Need an image!");
                } else {
                    LOI_Interpolator_Tool.this.showStraightenedStack(image);
                }
            }
        });
        gd.addButton("Find peaks [P]", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gd.dispose();
                ImagePlus image = WindowManager.getCurrentImage();
                if (image == null) {
                    IJ.error((String)"Need an image!");
                } else {
                    LOI_Interpolator_Tool.this.showPeaks(image);
                }
            }
        });
        gd.addButton("Adjust line width [Ctrl+mouse wheel]", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gd.dispose();
                IJ.runPlugIn((String)"ij.plugin.frame.LineWidthAdjuster", (String)"");
            }
        });
        this.addIOButtons(gd);
        gd.showDialog();
    }

    public void toolToggled(boolean enabled) {
    }

    protected boolean updateROI(ImagePlus image) {
        Roi roi = image.getRoi();
        if (roi == null || !(roi instanceof PolygonRoi)) {
            if (this.constructing && this.roi != null) {
                return true;
            }
            this.roi = null;
            return false;
        }
        if (this.roi == roi) {
            return true;
        }
        if (roi instanceof PolygonRoiPublic) {
            this.roi = (PolygonRoiPublic)roi;
        } else {
            this.roi = new PolygonRoiPublic((PolygonRoi)roi);
            image.setRoi(roi);
            roi.setImage(image);
        }
        return true;
    }

    protected static boolean specifiedByUser(Roi roi) {
        return roi != null && roi instanceof PolygonRoiPublic && ((PolygonRoiPublic)roi).specifiedByUser;
    }

    protected void interpolateFrom(Roi[] rois, int currentSlice) {
        int i;
        boolean interpolated = false;
        for (i = currentSlice - 1; i > 0; --i) {
            if (!LOI_Interpolator_Tool.specifiedByUser(rois[i - 1])) continue;
            LOI_Interpolator_Tool.interpolateROIs(rois, i, currentSlice);
            interpolated = true;
            break;
        }
        if (!interpolated) {
            LOI_Interpolator_Tool.interpolateROIs(rois, 0, currentSlice);
        } else {
            interpolated = false;
        }
        for (i = currentSlice + 1; i <= rois.length; ++i) {
            if (!LOI_Interpolator_Tool.specifiedByUser(rois[i - 1])) continue;
            LOI_Interpolator_Tool.interpolateROIs(rois, currentSlice, i);
            interpolated = true;
            break;
        }
        if (!interpolated) {
            LOI_Interpolator_Tool.interpolateROIs(rois, currentSlice, rois.length + 1);
        }
    }

    protected static void interpolateROIs(Roi[] rois) {
        int previousSlice = 0;
        for (int slice = 1; slice <= rois.length; ++slice) {
            if (!LOI_Interpolator_Tool.specifiedByUser(rois[slice - 1])) continue;
            LOI_Interpolator_Tool.interpolateROIs(rois, previousSlice, slice);
            previousSlice = slice;
        }
        if (previousSlice > 0) {
            LOI_Interpolator_Tool.interpolateROIs(rois, previousSlice, rois.length + 1);
        }
    }

    protected static void interpolateROIs(Roi[] rois, int from, int to) {
        if (from >= to) {
            return;
        }
        Polygon poly1 = LOI_Interpolator_Tool.getPolygon(rois, from > 0 ? from - 1 : to - 1);
        Polygon poly2 = LOI_Interpolator_Tool.getPolygon(rois, to <= rois.length ? to - 1 : from - 1);
        LOI_Interpolator_Tool.normalizePointCounts(poly1, poly2);
        for (int j = from; j < to - 1; ++j) {
            int[] x = new int[poly1.npoints];
            int[] y = new int[poly1.npoints];
            for (int k = 0; k < poly1.npoints; ++k) {
                x[k] = poly1.xpoints[k] + (j + 1 - from) * (poly2.xpoints[k] - poly1.xpoints[k]) / (to - from);
                y[k] = poly1.ypoints[k] + (j + 1 - from) * (poly2.ypoints[k] - poly1.ypoints[k]) / (to - from);
            }
            rois[j] = new PolygonRoiPublic(x, y, poly1.npoints, 6);
            ((PolygonRoiPublic)rois[j]).updatePolygon();
        }
    }

    protected static void normalizePointCounts(Polygon poly1, Polygon poly2) {
        if (poly1.npoints != poly2.npoints) {
            int n = poly1.npoints + poly2.npoints;
            LOI_Interpolator_Tool.resamplePolygon(poly1, n);
            LOI_Interpolator_Tool.resamplePolygon(poly2, n);
        }
    }

    protected static void resamplePolygon(Polygon polygon, int npoints) {
        int[] x = new int[npoints];
        int[] y = new int[npoints];
        PolygonRoi roi = new PolygonRoi(polygon, 6);
        roi.fitSpline();
        FloatPolygon floatPolygon = roi.getFloatPolygon();
        float[] x1 = floatPolygon.xpoints;
        float[] y1 = floatPolygon.ypoints;
        for (int i = 0; i < npoints; ++i) {
            float index = (float)(i * (floatPolygon.npoints - 1)) / (float)(npoints - 1);
            int j = (int)Math.floor(index);
            float f1 = index - (float)j;
            if ((double)f1 < 1.0E-5) {
                x[i] = Math.round(x1[j]);
                y[i] = Math.round(y1[j]);
                continue;
            }
            float f2 = 1.0f - f1;
            x[i] = Math.round(x1[j] * f2 + x1[j + 1] * f1);
            y[i] = Math.round(y1[j] * f2 + y1[j + 1] * f1);
        }
        polygon.npoints = npoints;
        polygon.xpoints = x;
        polygon.ypoints = y;
    }

    protected static Polygon getPolygon(Roi[] rois, int sliceIndex) {
        if (rois[sliceIndex] == null || !(rois[sliceIndex] instanceof PolygonRoi)) {
            return null;
        }
        PolygonRoi roi = (PolygonRoi)rois[sliceIndex];
        if (roi.isSplineFit()) {
            roi = (PolygonRoi)roi.clone();
            roi.removeSplineFit();
        }
        return roi.getPolygon();
    }

    protected ImagePlus doRegistration(ImagePlus image, boolean showSpreadsheet) {
        Roi[] rois = this.getRois(image);
        if (rois == null) {
            return null;
        }
        PolygonRoi[] polygons = new PolygonRoi[rois.length];
        System.arraycopy(rois, 0, polygons, 0, rois.length);
        return LOI_Interpolator_Tool.showKymograph(image, polygons, Line.getWidth(), showSpreadsheet, false);
    }

    protected static ImagePlus showKymograph(ImagePlus image, PolygonRoi[] rois, int lineWidth, boolean showSpreadsheet, boolean useFullLineWidth) {
        int i;
        int linesPerROI = useFullLineWidth ? lineWidth : 1;
        int width = 0;
        int height = rois.length * linesPerROI;
        float[][] values = new float[height][];
        Straightener straightener = new Straightener();
        ImageStack stack = image.getStack();
        for (int i2 = 0; i2 < rois.length; ++i2) {
            if (rois[i2] == null) {
                for (int j = 0; j < linesPerROI; ++j) {
                    values[i2 * linesPerROI + j] = new float[0];
                }
                continue;
            }
            rois[i2].removeSplineFit();
            ImagePlus dummy = new ImagePlus("dummy", stack.getProcessor(i2 + 1));
            dummy.setRoi((Roi)rois[i2]);
            ImageProcessor ip = straightener.straightenLine(dummy, lineWidth);
            int w = ip.getWidth();
            if (!useFullLineWidth && lineWidth > 1) {
                for (int j = 0; j < w; ++j) {
                    float value = ip.getf(j, 0);
                    for (int k = 1; k < lineWidth; ++k) {
                        value += ip.getf(j, k);
                    }
                    ip.setf(j, 0, value / (float)lineWidth);
                }
            }
            float[] pixels = (float[])ip.getPixels();
            for (int j = 0; j < linesPerROI; ++j) {
                values[i2 * linesPerROI + j] = new float[w];
                System.arraycopy(pixels, j * w, values[i2 * linesPerROI + j], 0, w);
            }
            width = Math.max(ip.getWidth(), width);
        }
        if (width == 0) {
            IJ.error((String)"No ROIs!");
            return null;
        }
        if (showSpreadsheet) {
            ResultsTable table = new ResultsTable();
            for (i = 0; i < height; ++i) {
                table.incrementCounter();
                for (int j = 0; j < values[i].length; ++j) {
                    table.addValue(j, (double)values[i][j]);
                }
            }
            table.show("Kymograph values of " + image.getTitle());
        }
        float[] pixels = new float[width * height];
        for (i = 0; i < height; ++i) {
            System.arraycopy(values[i], 0, pixels, i * width, values[i].length);
        }
        FloatProcessor fp = new FloatProcessor(width, height, pixels, null);
        ImagePlus result = new ImagePlus("Kymograph of " + image.getTitle(), (ImageProcessor)fp);
        result.show();
        ImageCanvas canvas = result.getCanvas();
        KymographMouseListener listener = new KymographMouseListener(canvas, image, rois);
        canvas.addMouseMotionListener((MouseMotionListener)listener);
        result.getWindow().addWindowListener((WindowListener)listener);
        return result;
    }

    protected void exportToROIManager(ImagePlus image) {
        Roi[] rois = (Roi[])this.map.get(image);
        if (rois == null) {
            return;
        }
        int currentSlice = image.getCurrentSlice();
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            manager = new RoiManager();
        }
        for (int i = 0; i < rois.length; ++i) {
            if (!LOI_Interpolator_Tool.specifiedByUser(rois[i])) continue;
            image.setSliceWithoutUpdate(i + 1);
            manager.add(image, rois[i], i + 1);
        }
        image.setSlice(currentSlice);
    }

    protected void importFromROIManager() {
        ImagePlus image = WindowManager.getCurrentImage();
        if (image == null) {
            return;
        }
        Roi[] rois = this.getRois(image);
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            return;
        }
        List labels = manager.getList();
        Hashtable table = manager.getROIs();
        for (int i = 0; i < labels.getItemCount(); ++i) {
            String label = labels.getItem(i);
            int index = manager.getSliceNumber(label) - 1;
            if (index < 0 || index >= rois.length) continue;
            Object roi = (Roi)table.get(label);
            if (!(roi instanceof PolygonRoiPublic)) {
                if (!(roi instanceof PolygonRoi)) continue;
                roi = new PolygonRoiPublic((PolygonRoi)roi);
            }
            ((PolygonRoiPublic)((Object)roi)).specifiedByUser = true;
            rois[index] = roi;
        }
        LOI_Interpolator_Tool.interpolateROIs(rois);
        LOI_Interpolator_Tool.setRoi((ImagePlus)image, (Roi)rois[image.getCurrentSlice() - 1]);
    }

    protected void saveROIs(Roi[] rois, String path) {
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(path));
            DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
            RoiEncoder roiEncoder = new RoiEncoder((OutputStream)dataOut);
            for (int i = 0; i < rois.length; ++i) {
                if (!LOI_Interpolator_Tool.specifiedByUser(rois[i])) continue;
                out.putNextEntry(new ZipEntry(this.getROILabel(i + 1, rois.length, rois[i]) + ".roi"));
                roiEncoder.write(rois[i]);
                dataOut.flush();
            }
            dataOut.close();
        }
        catch (IOException e) {
            IJ.handleException((Throwable)e);
        }
    }

    protected void loadROIs(ImagePlus image, String path) {
        try {
            ZipEntry entry;
            Roi[] rois = new Roi[image.getStackSize()];
            byte[] buf = new byte[16384];
            ZipInputStream in = new ZipInputStream(new FileInputStream(path));
            while ((entry = in.getNextEntry()) != null) {
                int count;
                int slice;
                String name = entry.getName();
                if (!entry.getName().endsWith(".roi")) continue;
                int minus = name.indexOf(45);
                try {
                    slice = Integer.parseInt(minus < 0 ? name : name.substring(0, minus));
                }
                catch (NumberFormatException e) {
                    IJ.log((String)("Skipping ROI with invalid name: " + name));
                    continue;
                }
                if (slice < 1 || slice > rois.length) {
                    IJ.log((String)("Skipping ROI for invalid slice: " + slice));
                    continue;
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                while ((count = in.read(buf)) >= 0) {
                    buffer.write(buf, 0, count);
                }
                RoiDecoder roiDecoder = new RoiDecoder(buffer.toByteArray(), entry.getName());
                Object roi = roiDecoder.getRoi();
                if (roi == null) continue;
                if (!(roi instanceof PolygonRoiPublic)) {
                    if (!(roi instanceof PolygonRoi)) continue;
                    roi = new PolygonRoiPublic((PolygonRoi)roi);
                }
                ((PolygonRoiPublic)((Object)roi)).specifiedByUser = true;
                rois[slice - 1] = roi;
            }
            in.close();
            this.map.put(image, rois);
            LOI_Interpolator_Tool.interpolateROIs(rois);
            LOI_Interpolator_Tool.setRoi((ImagePlus)image, (Roi)rois[image.getCurrentSlice() - 1]);
        }
        catch (IOException e) {
            IJ.handleException((Throwable)e);
        }
    }

    protected void showStraightenedStack(ImagePlus image) {
        ImagePlus result = this.getStraightenedStack(image);
        if (result != null) {
            result.show();
        }
    }

    protected ImagePlus getStraightenedStack(ImagePlus image) {
        if (image == null) {
            return null;
        }
        return LOI_Interpolator_Tool.getStraightenedStack(image, Line.getWidth(), this.getRois(image));
    }

    protected static ImagePlus getStraightenedStack(ImagePlus image, int lineWidth, Roi[] rois) {
        if (rois == null) {
            return null;
        }
        Straightener straightener = new Straightener();
        int w = 1;
        int h = lineWidth;
        ImageStack stack = image.getStack();
        ImageStack result = new ImageStack(w, h);
        CanvasResizer resizer = new CanvasResizer();
        try {
            Field zeroFill = resizer.getClass().getDeclaredField("zeroFill");
            zeroFill.setAccessible(true);
            zeroFill.set(resizer, Boolean.TRUE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < rois.length; ++i) {
            if (rois[i] == null) {
                result.addSlice("", (ImageProcessor)new FloatProcessor(w, h));
                continue;
            }
            ImagePlus dummy = new ImagePlus("dummy", stack.getProcessor(i + 1));
            dummy.setRoi(rois[i]);
            ImageProcessor ip2 = straightener.straightenLine(dummy, lineWidth);
            if (w < ip2.getWidth()) {
                w = ip2.getWidth();
                result = result.getSize() > 0 ? resizer.expandStack(result, w, h, 0, 0) : new ImageStack(w, h);
            } else if (w > ip2.getWidth()) {
                ip2 = resizer.expandImage(ip2, w, h, 0, 0);
            }
            result.addSlice("", ip2);
        }
        return new ImagePlus("Straightened-" + image.getTitle(), result);
    }

    public void showPeaks(ImagePlus image) {
        this.showPeaks(image, this.getRois(image));
    }

    public void showPeaks(ImagePlus image, Roi[] rois) {
        this.showPeaks(image, this.toPolygonRois(rois));
    }

    public void showPeaks(ImagePlus image, PolygonRoi[] rois) {
        if (rois == null) {
            return;
        }
        new ProfileStack(image, rois).show();
        new Peak_Counter_Tool().run("");
    }

    protected PolygonRoi[] toPolygonRois(Roi[] rois) {
        if (rois == null) {
            return null;
        }
        PolygonRoi[] polygons = new PolygonRoi[rois.length];
        for (int i = 0; i < rois.length; ++i) {
            if (!(rois[i] instanceof PolygonRoi)) continue;
            polygons[i] = (PolygonRoi)rois[i];
        }
        return polygons;
    }
}

