/*
 * Decompiled with CFR 0.152.
 */
package fiji.process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class EDT
implements PlugInFilter {
    ImagePlus image;
    int w;
    int h;
    int d;
    int current;
    int total;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 129;
    }

    public void run(ImageProcessor ip) {
        this.compute(this.image.getStack()).show();
    }

    public ImagePlus compute(ImageStack stack) {
        this.w = stack.getWidth();
        this.h = stack.getHeight();
        this.d = stack.getSize();
        ImageStack result = new ImageStack(this.w, this.h, this.d);
        for (int i = 1; i <= this.d; ++i) {
            result.setPixels((Object)new float[this.w * this.h], i);
        }
        this.current = 0;
        this.total = this.w * this.h * this.d * 3;
        new Z(stack, result).compute();
        new Y(result).compute();
        new X(result).compute();
        return new ImagePlus("EDT", result);
    }

    class X
    extends OneDimension {
        X(ImageStack out) {
            super(out, true);
        }

        @Override
        final void set(int x, float value) {
            this.slice[x * this.columnStride + this.offset] = (float)Math.sqrt(value);
        }
    }

    class Y
    extends OneDimension {
        Y(ImageStack out) {
            super(out, false);
        }

        @Override
        final void set(int x, float value) {
            this.slice[x * this.columnStride + this.offset] = value;
        }
    }

    abstract class OneDimension
    extends EDTBase {
        ImageStack stack;
        float[] slice;
        int offset;
        int lastOffset;
        int rowStride;
        int columnStride;
        int sliceIndex;

        OneDimension(ImageStack out, boolean iterateX) {
            super(iterateX ? EDT.this.w : EDT.this.h);
            this.stack = out;
            this.columnStride = iterateX ? 1 : EDT.this.w;
            this.rowStride = iterateX ? EDT.this.w : 1;
            this.offset = EDT.this.w * EDT.this.h;
            this.lastOffset = this.rowStride * (iterateX ? EDT.this.h : EDT.this.w);
            this.sliceIndex = -1;
        }

        @Override
        final float get(int x) {
            return this.slice[x * this.columnStride + this.offset];
        }

        @Override
        final boolean nextRow() {
            this.offset += this.rowStride;
            if (this.offset >= this.lastOffset) {
                if (++this.sliceIndex >= EDT.this.d) {
                    return false;
                }
                this.offset = 0;
                this.slice = (float[])this.stack.getPixels(this.sliceIndex + 1);
            }
            return true;
        }
    }

    class Z
    extends EDTBase {
        byte[][] inSlice;
        float[][] outSlice;
        int offset;

        Z(ImageStack in, ImageStack out) {
            super(EDT.this.d);
            this.inSlice = new byte[EDT.this.d][];
            this.outSlice = new float[EDT.this.d][];
            for (int i = 0; i < EDT.this.d; ++i) {
                this.inSlice[i] = (byte[])in.getPixels(i + 1);
                this.outSlice[i] = (float[])out.getPixels(i + 1);
            }
            this.offset = -1;
        }

        @Override
        final float get(int x) {
            return this.inSlice[x][this.offset] == 0 ? 0.0f : Float.MAX_VALUE;
        }

        @Override
        final void set(int x, float value) {
            this.outSlice[x][this.offset] = value;
        }

        @Override
        final boolean nextRow() {
            return ++this.offset < EDT.this.w * EDT.this.h;
        }
    }

    abstract class EDTBase {
        int width;
        int k;
        float[] f;
        float[] z;
        int[] y;

        EDTBase(int rowWidth) {
            this.width = rowWidth;
            this.f = new float[this.width + 1];
            this.z = new float[this.width + 1];
            this.y = new int[this.width + 1];
        }

        final void computeRow() {
            this.f[0] = Float.MAX_VALUE;
            this.y[0] = -1;
            this.z[0] = Float.MAX_VALUE;
            this.k = 0;
            int x = 0;
            while (x < this.width) {
                float s;
                float fx = this.get(x);
                while (!((s = (fx + (float)(x * x) - (this.f[this.k] + (float)(this.y[this.k] * this.y[this.k]))) / 2.0f / (float)(x - this.y[this.k])) > this.z[this.k]) && --this.k >= 0) {
                }
                ++this.k;
                this.y[this.k] = x++;
                this.f[this.k] = fx;
                this.z[this.k] = s;
            }
            this.z[++this.k] = Float.MAX_VALUE;
            int i = 0;
            for (int x2 = 0; x2 < this.width; ++x2) {
                while (this.z[i + 1] < (float)x2) {
                    ++i;
                }
                this.set(x2, (float)((x2 - this.y[i]) * (x2 - this.y[i])) + this.f[i]);
            }
        }

        abstract float get(int var1);

        abstract void set(int var1, float var2);

        final void compute() {
            while (this.nextRow()) {
                this.computeRow();
                if (EDT.this.total <= 0) continue;
                EDT.this.current += this.width;
                IJ.showProgress((int)EDT.this.current, (int)EDT.this.total);
            }
        }

        abstract boolean nextRow();
    }
}

