/*
 * Decompiled with CFR 0.152.
 */
package fiji.selection;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class Rounded_Rectangle
implements PlugInFilter {
    ImagePlus image;
    protected GeneralPath gp;
    protected int x;
    protected int y;
    protected static float kappa = (float)(4.0 * (Math.sqrt(2.0) - 1.0) / 3.0);

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 159;
    }

    public void run(ImageProcessor ip) {
        Roi roi;
        block5: {
            block4: {
                roi = this.image.getRoi();
                if (roi == null) break block4;
                if (roi.getType() == 0) break block5;
            }
            IJ.error((String)"Need a rectangular selection!");
            return;
        }
        Rectangle rect = roi.getBounds();
        int min = Math.min(rect.width, rect.height);
        GenericDialog gd = new GenericDialog("Make rectangle rounded");
        gd.addSlider("radius", 0.0, (double)(min / 2), (double)Math.min(5, min / 2));
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int radius = (int)gd.getNextNumber();
        this.gp = new GeneralPath();
        this.start(rect.x + radius, rect.y);
        this.quarterCircle(radius, -90);
        this.straight(0, rect.height - 2 * radius);
        this.quarterCircle(radius, -180);
        this.straight(rect.width - 2 * radius, 0);
        this.quarterCircle(radius, -270);
        this.straight(0, 2 * radius - rect.height);
        this.quarterCircle(radius, 0);
        this.gp.closePath();
        this.image.setRoi((Roi)new ShapeRoi((Shape)this.gp));
    }

    protected void start(int x, int y) {
        this.x = x;
        this.y = y;
        this.gp.moveTo(this.x, this.y);
    }

    protected void straight(int x, int y) {
        this.x += x;
        this.y += y;
        this.gp.lineTo(this.x, this.y);
    }

    protected void quarterCircle(int radius, int startAngle) {
        float dx = (float)Math.cos(Math.PI * (double)startAngle / 180.0) * (float)radius;
        float dy = (float)Math.sin(Math.PI * (double)startAngle / 180.0) * (float)radius;
        float x1 = (float)this.x + (1.0f - kappa) * dy;
        float y1 = (float)this.y + (1.0f - kappa) * -dx;
        this.x = (int)((float)this.x + (dy - dx));
        this.y = (int)((float)this.y + (-dx - dy));
        float x2 = (float)this.x + (1.0f - kappa) * dx;
        float y2 = (float)this.y + (1.0f - kappa) * dy;
        this.gp.curveTo(x1, y1, x2, y2, this.x, this.y);
    }

    void debug(GeneralPath gp) {
        PathIterator iter = gp.getPathIterator(new AffineTransform());
        double[] coords = new double[6];
        while (!iter.isDone()) {
            int type = iter.currentSegment(coords);
            switch (type) {
                case 4: {
                    System.err.println("close");
                    break;
                }
                case 3: {
                    System.err.println("cubic (" + coords[0] + ", " + coords[1] + ") (" + coords[2] + ", " + coords[3] + ") (" + coords[4] + ", " + coords[5] + ")");
                    break;
                }
                case 2: {
                    System.err.println("quad (" + coords[0] + ", " + coords[1] + ") (" + coords[2] + ", " + coords[3] + ")");
                    break;
                }
                case 0: 
                case 1: {
                    System.err.println((type == 1 ? "line" : "move") + "to (" + coords[0] + ", " + coords[1] + ")");
                    break;
                }
                default: {
                    System.err.println("unknown type: " + type);
                }
            }
            iter.next();
        }
    }
}

