/*
 * Decompiled with CFR 0.152.
 */
package fiji.stacks;

import fiji.stacks.CompositeConverter2;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;

public class Hyperstack_rearranger
implements PlugIn {
    public static int defaultIndexChannels = 0;
    public static int defaultIndexSlices = 1;
    public static int defaultIndexFrames = 2;
    public String[] choice = new String[]{"Channels (c)", "Slices (z)", "Frames (t)"};

    public void run(String arg0) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.log((String)"No images open.");
            return;
        }
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        if (nChannels + nFrames + nSlices == 1) {
            IJ.log((String)"This is only a 2d-image.");
            return;
        }
        GenericDialog gd = new GenericDialog("Re-order Hyperstack [" + imp.getTitle() + "]");
        gd.addChoice("Channels (c) -> ", this.choice, this.choice[defaultIndexChannels]);
        gd.addChoice("Slices (z) -> ", this.choice, this.choice[defaultIndexSlices]);
        gd.addChoice("Frames (t) -> ", this.choice, this.choice[defaultIndexFrames]);
        gd.addMessage("");
        gd.addMessage("Current number of channels: " + nChannels);
        gd.addMessage("Current number of slices: " + nSlices);
        gd.addMessage("Current number of frames: " + nFrames);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int indexChannels = gd.getNextChoiceIndex();
        int indexSlices = gd.getNextChoiceIndex();
        int indexFrames = gd.getNextChoiceIndex();
        int[] verify = new int[3];
        int n = indexChannels;
        verify[n] = verify[n] + 1;
        int n2 = indexSlices;
        verify[n2] = verify[n2] + 1;
        int n3 = indexFrames;
        verify[n3] = verify[n3] + 1;
        if (verify[0] != 1 || verify[1] != 1 || verify[2] != 1) {
            IJ.log((String)"Mapping is inconsistent: each - channel, slices and frames have to be assigned to an input dimension.");
            return;
        }
        defaultIndexChannels = indexChannels;
        defaultIndexSlices = indexSlices;
        defaultIndexFrames = indexFrames;
        Hyperstack_rearranger.reorderHyperstack(imp, indexChannels, indexSlices, indexFrames, true, true);
    }

    public static ImagePlus reorderHyperstack(ImagePlus imp, String newOrder, boolean closeOldImp, boolean showNewImp) {
        if (newOrder.equalsIgnoreCase("CZT")) {
            return Hyperstack_rearranger.reorderHyperstack(imp, 0, 1, 2, closeOldImp, showNewImp);
        }
        if (newOrder.equalsIgnoreCase("CTZ")) {
            return Hyperstack_rearranger.reorderHyperstack(imp, 0, 2, 1, closeOldImp, showNewImp);
        }
        if (newOrder.equalsIgnoreCase("ZCT")) {
            return Hyperstack_rearranger.reorderHyperstack(imp, 1, 0, 2, closeOldImp, showNewImp);
        }
        if (newOrder.equalsIgnoreCase("ZTC")) {
            return Hyperstack_rearranger.reorderHyperstack(imp, 1, 2, 0, closeOldImp, showNewImp);
        }
        if (newOrder.equalsIgnoreCase("TCZ")) {
            return Hyperstack_rearranger.reorderHyperstack(imp, 2, 0, 1, closeOldImp, showNewImp);
        }
        if (newOrder.equalsIgnoreCase("TZC")) {
            return Hyperstack_rearranger.reorderHyperstack(imp, 2, 1, 0, closeOldImp, showNewImp);
        }
        IJ.log((String)("Unknown reordering: " + newOrder));
        return null;
    }

    public static CompositeImage reorderHyperstack(ImagePlus imp, int targetChannels, int targetSlices, int targetFrames, boolean closeOldImp, boolean showNewImp) {
        int[] dimensions = new int[]{imp.getNChannels(), imp.getNSlices(), imp.getNFrames()};
        int[] newAssignment = new int[]{targetChannels, targetSlices, targetFrames};
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        int nChannelsNew = dimensions[newAssignment[0]];
        int nSlicesNew = dimensions[newAssignment[1]];
        int nFramesNew = dimensions[newAssignment[2]];
        int[] indexTmp = new int[3];
        for (int t = 1; t <= nFramesNew; ++t) {
            for (int z = 1; z <= nSlicesNew; ++z) {
                int c = 1;
                while (c <= nChannelsNew) {
                    indexTmp[newAssignment[0]] = c++;
                    indexTmp[newAssignment[1]] = z;
                    indexTmp[newAssignment[2]] = t;
                    int index = imp.getStackIndex(indexTmp[0], indexTmp[1], indexTmp[2]);
                    ImageProcessor ip = imp.getStack().getProcessor(index);
                    stack.addSlice(imp.getStack().getSliceLabel(index), ip);
                }
            }
        }
        ImagePlus newImp = new ImagePlus(imp.getTitle(), stack);
        newImp.setDimensions(nChannelsNew, nSlicesNew, nFramesNew);
        newImp.setCalibration(imp.getCalibration());
        CompositeImage c = new CompositeImage(newImp, 1);
        if (targetChannels == 0) {
            c.setLuts(imp.getLuts());
        }
        if (closeOldImp) {
            imp.close();
        }
        if (showNewImp) {
            c.show();
        }
        return c;
    }

    public static ImagePlus getImageChunk(ImagePlus imp, int channel, int timepoint) {
        if (imp.getNSlices() == 1) {
            return new ImagePlus("", imp.getStack().getProcessor(imp.getStackIndex(channel, 1, timepoint)));
        }
        ImageStack stack = new ImageStack(imp.getWidth(), imp.getHeight());
        for (int z = 1; z <= imp.getNSlices(); ++z) {
            int index = imp.getStackIndex(channel, z, timepoint);
            ImageProcessor ip = imp.getStack().getProcessor(index);
            stack.addSlice(imp.getStack().getSliceLabel(index), ip);
        }
        return new ImagePlus("", stack);
    }

    public static ImagePlus convertToHyperStack(ImagePlus imp) {
        if (imp.getType() == 3) {
            if (imp.getStackSize() > 1) {
                new StackConverter(imp).convertToRGB();
            } else {
                new ImageConverter(imp).convertToRGB();
            }
        }
        Calibration cal = imp.getCalibration();
        if (imp.getType() == 4) {
            imp = new CompositeConverter2().makeComposite(imp);
            imp.setCalibration(cal);
        }
        return imp;
    }
}

