/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import fiji.util.KDTree;
import fiji.util.node.Leaf;
import fiji.util.node.Node;
import fiji.util.node.NonLeaf;
import java.util.Arrays;
import java.util.Comparator;

public class NNearestNeighborSearch<T extends Leaf<T>> {
    protected final KDTree<T> kdTree;

    public NNearestNeighborSearch(KDTree<T> kdTree) {
        this.kdTree = kdTree;
    }

    public KDTree<T> getKDTree() {
        return this.kdTree;
    }

    public T[] findNNearestNeighbors(T point, int n) {
        Leaf[] result = point.createArray(n);
        int count = this.findNNearestNeighbors((Leaf)point, this.kdTree.getRoot(), 0, 0, result);
        if (count < result.length) {
            Leaf[] newResult = point.createArray(count);
            for (int i = 0; i < count; ++i) {
                newResult[i] = result[i];
            }
            return newResult;
        }
        return result;
    }

    public int findNNearestNeighbors(T point, Node<T> node, int depth, int gotAlready, T[] result) {
        if (node.isLeaf()) {
            int index;
            Leaf leaf = (Leaf)node;
            if (gotAlready == 0) {
                result[0] = leaf;
                return 1;
            }
            if (gotAlready < result.length) {
                for (index = 0; index < gotAlready && point.distanceTo(result[index]) < point.distanceTo((Leaf)leaf); ++index) {
                }
            } else {
                index = Arrays.binarySearch(result, leaf, new Comparator((Leaf)point){
                    final /* synthetic */ Leaf val$point;
                    {
                        this.val$point = leaf;
                    }

                    public int compare(Object a, Object b) {
                        float distB;
                        float distA = this.val$point.distanceTo((Leaf)a);
                        return distA < (distB = this.val$point.distanceTo((Leaf)b)) ? -1 : (distA > distB ? 1 : 0);
                    }

                    public boolean equals(Object a, Object b) {
                        return a.equals(b);
                    }
                });
                if (index < 0) {
                    index = -1 - index;
                }
            }
            if (index < result.length) {
                if (gotAlready < result.length) {
                    if (index < gotAlready) {
                        System.arraycopy(result, index, result, index + 1, gotAlready - index);
                    }
                    ++gotAlready;
                } else if (index + 1 < result.length) {
                    System.arraycopy(result, index, result, index + 1, result.length - index - 1);
                }
                result[index] = leaf;
            }
            return gotAlready;
        }
        int k = depth % this.kdTree.getDimension();
        NonLeaf nonLeaf = (NonLeaf)node;
        if (nonLeaf.right == null) {
            return this.findNNearestNeighbors((Leaf)point, nonLeaf.left, depth + 1, gotAlready, (Leaf[])result);
        }
        if (nonLeaf.left == null) {
            return this.findNNearestNeighbors((Leaf)point, nonLeaf.right, depth + 1, gotAlready, (Leaf[])result);
        }
        float projectedDistance = nonLeaf.coordinate - point.get(k);
        boolean lookRight = projectedDistance < 0.0f;
        gotAlready = this.findNNearestNeighbors((Leaf)point, lookRight ? nonLeaf.right : nonLeaf.left, depth + 1, gotAlready, (Leaf[])result);
        float distance = point.distanceTo(result[gotAlready - 1]);
        if (gotAlready < result.length || distance > Math.abs(projectedDistance)) {
            gotAlready = this.findNNearestNeighbors((Leaf)point, lookRight ? nonLeaf.left : nonLeaf.right, depth + 1, gotAlready, (Leaf[])result);
        }
        return gotAlready;
    }

    public String toString(T leaf) {
        if (leaf == null) {
            return "null";
        }
        int dimension = this.kdTree.getDimension();
        String result = "(" + leaf.get(0);
        for (int i = 1; i < dimension; ++i) {
            result = result + ", " + leaf.get(i);
        }
        return result + ")";
    }

    public String toString(T[] array, int length) {
        if (length == 0) {
            return "[]";
        }
        String result = "[" + this.toString(array[0]);
        for (int i = 1; i < length; ++i) {
            result = result + ", " + this.toString(array[i]);
        }
        return result + "]";
    }
}

