/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import fiji.util.KDTree;
import fiji.util.NNearestNeighborSearch;
import fiji.util.NearestNeighborSearch;
import fiji.util.node.SimpleNode;
import java.util.ArrayList;
import java.util.Random;

public class TestKDTree {
    protected static boolean testNNearestNeighbor(int neighbors, int numDimensions, int numPoints, int numTests, float min, float max) {
        ArrayList<SimpleNode> points = new ArrayList<SimpleNode>();
        Random rnd = new Random(435435435L);
        float[] p = new float[numDimensions];
        for (int i = 0; i < numPoints; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (max - min) + min;
            }
            SimpleNode t = new SimpleNode(p);
            points.add(t);
        }
        long start = System.currentTimeMillis();
        KDTree kdTree = new KDTree(points);
        NNearestNeighborSearch kd = new NNearestNeighborSearch(kdTree);
        long kdSetupTime = System.currentTimeMillis() - start;
        System.out.println("kdtree setup took: " + kdSetupTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode[] nnKdtree = (SimpleNode[])kd.findNNearestNeighbors(t, neighbors);
            SimpleNode[] nnExhaustive = TestKDTree.findNNearestNeighborExhaustive(points, t, neighbors);
            for (int j = 0; j < neighbors; ++j) {
                if (nnKdtree[j].equals(nnExhaustive[j])) continue;
                System.out.println(j + 1 + " - Nearest neighbor to: " + t);
                System.out.println("KD-Tree says: " + nnKdtree[j] + " (" + nnKdtree[j].distanceTo(t) + ")");
                System.out.println("Exhaustive says: " + nnExhaustive[j] + " (" + nnExhaustive[j].distanceTo(t) + ")");
                return false;
            }
        }
        long compareTime = System.currentTimeMillis() - start;
        System.out.println("comparison (kd-exhaustive) search took: " + compareTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode simpleNode = new SimpleNode(p);
        }
        long initTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode[] simpleNodeArray = (SimpleNode[])kd.findNNearestNeighbors(t, neighbors);
        }
        long kdTime = System.currentTimeMillis() - start;
        System.out.println("kdtree search took: " + (kdTime - initTime) + " ms.");
        System.out.println("kdtree all together took: " + (kdSetupTime + kdTime - initTime) + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode[] simpleNodeArray = TestKDTree.findNNearestNeighborExhaustive(points, t, neighbors);
        }
        long exhaustiveTime = System.currentTimeMillis() - start;
        System.out.println("exhaustive search took: " + (exhaustiveTime - initTime) + " ms.");
        return true;
    }

    protected static boolean testNearestNeighbor(int numDimensions, int numPoints, int numTests, float min, float max) {
        ArrayList<SimpleNode> points = new ArrayList<SimpleNode>();
        Random rnd = new Random(435435435L);
        float[] p = new float[numDimensions];
        for (int i = 0; i < numPoints; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (max - min) + min;
            }
            SimpleNode t = new SimpleNode(p);
            points.add(t);
        }
        long start = System.currentTimeMillis();
        KDTree kdTree = new KDTree(points);
        NearestNeighborSearch kd = new NearestNeighborSearch(kdTree);
        long kdSetupTime = System.currentTimeMillis() - start;
        System.out.println("kdtree setup took: " + kdSetupTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            SimpleNode nnExhaustive;
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode nnKdtree = kd.findNearestNeighbor(t);
            if (nnKdtree.equals(nnExhaustive = TestKDTree.findNearestNeighborExhaustive(points, t))) continue;
            System.out.println("Nearest neighbor to: " + t);
            System.out.println("KD-Tree says: " + nnKdtree);
            System.out.println("Exhaustive says: " + nnExhaustive);
            return false;
        }
        long compareTime = System.currentTimeMillis() - start;
        System.out.println("comparison (kd-exhaustive) search took: " + compareTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode simpleNode = new SimpleNode(p);
        }
        long initTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode simpleNode = kd.findNearestNeighbor(t);
        }
        long kdTime = System.currentTimeMillis() - start;
        System.out.println("kdtree search took: " + (kdTime - initTime) + " ms.");
        System.out.println("kdtree all together took: " + (kdSetupTime + kdTime - initTime) + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode simpleNode = TestKDTree.findNearestNeighborExhaustive(points, t);
        }
        long exhaustiveTime = System.currentTimeMillis() - start;
        System.out.println("exhaustive search took: " + (exhaustiveTime - initTime) + " ms.");
        return true;
    }

    private static SimpleNode findNearestNeighborExhaustive(ArrayList<SimpleNode> points, SimpleNode t) {
        float minDistance = Float.MAX_VALUE;
        SimpleNode nearest = null;
        for (SimpleNode n : points) {
            float dist = n.distanceTo(t);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            nearest = n;
        }
        return new SimpleNode(nearest);
    }

    private static SimpleNode[] findNNearestNeighborExhaustive(ArrayList<SimpleNode> points, SimpleNode t, int n) {
        SimpleNode[] nearest = new SimpleNode[n];
        float[] minDistance = new float[n];
        for (int i = 0; i < n; ++i) {
            minDistance[i] = Float.MAX_VALUE;
        }
        block1: for (SimpleNode node : points) {
            float dist = node.distanceTo(t);
            for (int i = 0; i < n; ++i) {
                if (!(dist < minDistance[i])) continue;
                for (int j = n - 2; j >= i; --j) {
                    nearest[j + 1] = nearest[j];
                    minDistance[j + 1] = minDistance[j];
                }
                nearest[i] = node;
                minDistance[i] = dist;
                continue block1;
            }
        }
        return nearest;
    }

    public static void main(String[] args) {
        if (TestKDTree.testNNearestNeighbor(3, 3, 100000, 1000, -5.0f, 5.0f)) {
            System.out.println("N-Nearest neighbor test (3) successfull\n");
        }
        if (TestKDTree.testNearestNeighbor(3, 100000, 1000, -5.0f, 5.0f)) {
            System.out.println("Nearest neighbor test successfull\n");
        }
        ArrayList<SimpleNode> points = new ArrayList<SimpleNode>();
        points.add(new SimpleNode(new float[]{1.0f, 1.0f, 0.0f}));
        points.add(new SimpleNode(new float[]{0.0f, 1.0f, 1.0f}));
        points.add(new SimpleNode(new float[]{1.0f, 0.0f, 1.0f}));
        KDTree kdTree = new KDTree(points);
        NNearestNeighborSearch nns = new NNearestNeighborSearch(kdTree);
        SimpleNode ref = new SimpleNode(new float[]{2.0f, 0.0f, 0.0f});
        SimpleNode[] nn = (SimpleNode[])nns.findNNearestNeighbors(ref, 2);
        System.out.println(nn[0]);
        System.out.println(nn[1]);
        System.exit(0);
    }
}

