/*
 * Decompiled with CFR 0.152.
 */
package fiji.util.node;

import fiji.util.node.Leaf;
import fiji.util.node.Node;

public class NonLeaf<T extends Leaf<T>>
implements Node<T> {
    public final float coordinate;
    public final Node<T> left;
    public final Node<T> right;
    final int dimension;

    public NonLeaf(float coordinate, int dimension, Node<T> left, Node<T> right) {
        this.coordinate = coordinate;
        this.left = left;
        this.right = right;
        this.dimension = dimension;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public String toString(Node<T> node) {
        if (node == null) {
            return "null";
        }
        if (node instanceof Leaf) {
            String result = "(" + ((Leaf)node).get(0);
            for (int i = 1; i < this.dimension; ++i) {
                result = result + ", " + ((Leaf)node).get(i);
            }
            return result + ")";
        }
        if (node instanceof NonLeaf) {
            NonLeaf nonLeaf = (NonLeaf)node;
            return "[" + this.toString(nonLeaf.left) + " |{" + nonLeaf.coordinate + "} " + this.toString(nonLeaf.right) + "]";
        }
        return node.toString();
    }

    public String toString() {
        return this.toString(this);
    }
}

