/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.function.ImgLibFunction;
import java.util.Stack;
import net.imglib2.algorithm.fft.Bandpass;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class ImgLibBandPassFilter<T extends RealType<T>>
extends PostfixMathCommand
implements ImgLibFunction<T> {
    public ImgLibBandPassFilter() {
        this.numberOfParameters = 3;
    }

    public void run(Stack stack) throws ParseException {
        Object param3 = stack.pop();
        Object param2 = stack.pop();
        Object param1 = stack.pop();
        if (!(param1 instanceof Img)) {
            throw new ParseException("In function '" + this.getFunctionString() + "': First operand must be an image.");
        }
        Img img = (Img)param1;
        if (!(param2 instanceof FloatType)) {
            throw new ParseException("In function '" + this.getFunctionString() + "': Second and third operands must be numbers.");
        }
        int begin_radius = (int)((FloatType)param2).get();
        if (!(param3 instanceof FloatType)) {
            throw new ParseException("In function '" + this.getFunctionString() + "': Second and third operands must be numbers.");
        }
        int end_radius = (int)((FloatType)param3).get();
        Bandpass filter = new Bandpass(img, begin_radius, end_radius);
        filter.process();
        stack.push(filter.getResult());
    }

    @Override
    public String getDocumentationString() {
        return "<h3>FFT bandpass filter</h3> This function filters its input in fourier space. Syntax: <br><code>" + this.getFunctionString() + "(A, begin_radius, end_radius)</code><br> where A is an image, and begin_radius and  end_radius are integers. Thw two radiuses are given in pixel units in the fourier space.";
    }

    @Override
    public String getFunctionString() {
        return "bandpass";
    }
}

