/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.classes;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.app.AppService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.SearchResult;
import org.scijava.search.Searcher;
import org.scijava.search.classes.ClassSearchResult;
import org.scijava.util.Types;

@Plugin(type=Searcher.class)
public class ClassesSearcher
implements Searcher {
    @Parameter
    private AppService appService;
    @Parameter
    private LogService log;

    @Override
    public String title() {
        return "Classes";
    }

    @Override
    public List<SearchResult> search(String text, boolean fuzzy) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        String baseDir = this.appService.getApp().getBaseDirectory().getAbsolutePath();
        LinkedHashSet matches = new LinkedHashSet();
        List<Class<?>> classes = this.getClasses();
        String textLower = text.toLowerCase();
        classes.stream().filter(c -> this.startsWith((Class<?>)c, textLower)).forEach(matches::add);
        classes.stream().filter(c -> this.hasSubstring((Class<?>)c, textLower)).forEach(matches::add);
        return matches.stream().map(c -> new ClassSearchResult((Class<?>)c, baseDir)).collect(Collectors.toList());
    }

    public static String location(Class<?> c, String baseDir) {
        String path = Types.location(c).toString();
        if (path == null) {
            return null;
        }
        if (path.startsWith("file:/")) {
            path = path.replaceFirst("file:/+", "/");
        }
        if (baseDir != null && path.startsWith(baseDir)) {
            if (path.length() == baseDir.length()) {
                return "";
            }
            path = path.substring(baseDir.length() + 1);
        }
        return path;
    }

    private List<Class<?>> getClasses() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object value = null;
        try {
            Field classesField = ClassLoader.class.getDeclaredField("classes");
            classesField.setAccessible(true);
            value = classesField.get(classLoader);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exc) {
            this.log.debug((Throwable)exc);
        }
        if (!(value instanceof List)) {
            return Collections.emptyList();
        }
        List classes = (List)value;
        return new ArrayList(classes);
    }

    private boolean startsWith(Class<?> c, String desiredLower) {
        return c.getName().toLowerCase().startsWith(desiredLower) || c.getSimpleName().toLowerCase().startsWith(desiredLower);
    }

    private boolean hasSubstring(Class<?> c, String desiredLower) {
        return c.getName().toLowerCase().matches(".*" + desiredLower + ".*");
    }
}

