/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.snippet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.search.SearchResult;
import org.scijava.search.SearchService;
import org.scijava.search.Searcher;
import org.scijava.search.snippet.SnippetSearchResult;

@Plugin(type=Searcher.class, priority=1000000.0)
public class SnippetSearcher
implements Searcher {
    @Parameter
    private ScriptService scriptService;
    @Parameter
    private SearchService searchService;

    @Override
    public String title() {
        return "Code snippets";
    }

    @Override
    public boolean supports(String text) {
        return text.startsWith("#!") || text.startsWith("!");
    }

    @Override
    public boolean exclusive(String text) {
        return text.startsWith("#!") || text.startsWith("!");
    }

    @Override
    public List<SearchResult> search(String text, boolean fuzzy) {
        if (!this.searchService.enabled(this)) {
            return new ArrayList<SearchResult>();
        }
        if (text.startsWith("#!")) {
            String[] tokens = text.split("\\s", 2);
            if (tokens.length < 2) {
                return Collections.emptyList();
            }
            String langHint = tokens[0];
            String snippet = tokens[1];
            return this.results(this.scriptService.getLanguages().stream().filter(language -> this.matches(langHint, language.getLanguageName()) || this.matches(langHint, language.getNames()) || this.matches(langHint, language.getExtensions())).collect(Collectors.toList()), snippet);
        }
        if (text.startsWith("!")) {
            return this.results(this.scriptService.getLanguages(), text.substring(1));
        }
        return Collections.emptyList();
    }

    private boolean matches(String actual, List<String> desiredList) {
        return desiredList.stream().filter(desired -> this.matches(actual, (String)desired)).findAny().isPresent();
    }

    private boolean matches(String actual, String desired) {
        return actual.toLowerCase().matches(".*" + desired + ".*");
    }

    private List<SearchResult> results(List<ScriptLanguage> languages, String snippet) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (ScriptLanguage language : languages) {
            results.add(new SnippetSearchResult(language, snippet));
        }
        return results;
    }
}

