/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.zoom;

import net.imagej.display.ImageCanvas;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.ZoomService;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.RealCoords;
import org.scijava.util.RealRect;

@Plugin(type=Command.class, label="Set Zoom...", menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Zoom", mnemonic=122), @Menu(label="Set...", weight=6.0)}, headless=true, initializer="initAll", attrs={@Attr(name="no-legacy")})
public class ZoomSet
extends DynamicCommand {
    private static final String ZOOM = "zoomPercent";
    private static final String CTR_U = "centerU";
    private static final String CTR_V = "centerV";
    @Parameter
    private ZoomService zoomService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(label="Zoom (%):", persist=false)
    private double zoomPercent;
    @Parameter(label="X center:", persist=false)
    private double centerU;
    @Parameter(label="Y center:", persist=false)
    private double centerV;

    public ImageDisplayService getImageDisplayService() {
        return this.imageDisplayService;
    }

    public void setImageDisplayService(ImageDisplayService imageDisplayService) {
        this.imageDisplayService = imageDisplayService;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public double getZoomPercent() {
        return this.zoomPercent;
    }

    public void setZoomPercent(double zoomPercent) {
        this.zoomPercent = zoomPercent;
    }

    public double getCenterU() {
        return this.centerU;
    }

    public void setCenterU(double centerU) {
        this.centerU = centerU;
    }

    public double getCenterV() {
        return this.centerV;
    }

    public void setCenterV(double centerV) {
        this.centerV = centerV;
    }

    public void run() {
        this.zoomService.zoomSet(this.display, this.zoomPercent, this.centerU, this.centerV);
    }

    protected void initAll() {
        this.initZoom();
        this.initCenter();
    }

    private void initZoom() {
        ImageCanvas canvas = this.display.getCanvas();
        MutableModuleItem zoomItem = this.getInfo().getMutableInput(ZOOM, Double.class);
        zoomItem.setMinimumValue((Object)0.1);
        zoomItem.setMaximumValue((Object)500000.0);
        this.setZoomPercent(100.0 * canvas.getZoomFactor());
    }

    private void initCenter() {
        RealRect planeExtents = this.display.getPlaneExtents();
        ImageCanvas canvas = this.display.getCanvas();
        RealCoords panCenter = canvas.getPanCenter();
        MutableModuleItem centerUItem = this.getInfo().getMutableInput(CTR_U, Double.class);
        centerUItem.setMinimumValue((Object)planeExtents.x);
        centerUItem.setMaximumValue((Object)(planeExtents.x + planeExtents.width));
        this.setCenterU(panCenter.x);
        MutableModuleItem centerVItem = this.getInfo().getMutableInput(CTR_V, Double.class);
        centerVItem.setMinimumValue((Object)planeExtents.y);
        centerVItem.setMaximumValue((Object)(planeExtents.y + planeExtents.height));
        this.setCenterV(panCenter.y);
    }
}

