/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfColor;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class ICCColorSpace
extends GenericColorSpace {
    private int[] a1 = new int[256];
    private int[] b1 = new int[256];
    private int[] c1 = new int[256];

    public ICCColorSpace(PdfObjectReader pdfObjectReader, String string) {
        byte[] byArray;
        int n;
        for (n = 0; n < 256; ++n) {
            this.a1[n] = -1;
            this.b1[n] = -1;
            this.c1[n] = -1;
        }
        this.value = 7;
        this.cs = ColorSpace.getInstance(1000);
        n = string.indexOf("/ICCBased");
        String string2 = string.substring(n + 9);
        if ((n = string2.indexOf("]")) != -1) {
            string2 = string2.substring(0, n - 1);
        }
        if ((byArray = pdfObjectReader.readStream(string2.trim(), true)) == null) {
            LogWriter.writeLog("Error in reading ICC data with ref " + string2);
        } else {
            try {
                this.cs = new ICC_ColorSpace(ICC_Profile.getInstance(byArray));
            }
            catch (Exception exception) {
                LogWriter.writeLog("[PDF] Problem " + exception.getMessage() + " with ICC data ");
                this.failed = true;
            }
        }
        this.componentCount = this.cs.getNumComponents();
    }

    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[n];
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            float f;
            fArray[n - i - 1] = f = Float.parseFloat(stringArray[i]);
            nArray[n - i - 1] = (int)(f * 255.0f);
        }
        if (n == 3 && this.a1[nArray[0]] != -1 && this.b1[nArray[1]] != -1 && this.c1[nArray[2]] != -1) {
            this.currentColor = new PdfColor(this.a1[nArray[0]], this.b1[nArray[1]], this.c1[nArray[2]]);
        } else {
            fArray = this.cs.toRGB(fArray);
            this.currentColor = new PdfColor(fArray[0], fArray[1], fArray[2]);
            if (n == 3) {
                this.a1[nArray[0]] = (int)(fArray[0] * 255.0f);
                this.b1[nArray[1]] = (int)(fArray[1] * 255.0f);
                this.c1[nArray[2]] = (int)(fArray[2] * 255.0f);
            }
        }
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        if (this.componentCount == 4) {
            return this.convert4Index(byArray);
        }
        return byArray;
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, String string) {
        int n3 = this.getJPEGTransform(byArray);
        if (this.componentCount == 3 && n3 == 0 && this.intent != null && this.intent.equals("/RelativeColorimetric")) {
            return this.algorithmicICCToRGB(byArray, n, n2, false);
        }
        return this.nonRGBJPEGToRGBImage(byArray, n, n2, null);
    }

    public BufferedImage algorithmicICCToRGB(byte[] byArray, int n, int n2, boolean bl) {
        BufferedImage bufferedImage = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            Raster raster = imageReader.readRaster(0, null);
            DataBuffer dataBuffer = raster.getDataBuffer();
            byte[] byArray2 = new byte[n * n2 * 3];
            int n3 = n * n2 * 3;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n4 = 0;
            float f4 = -1.0f;
            float f5 = -1.0f;
            float f6 = -1.0f;
            for (int i = 0; i < n3; i += 3) {
                float f7 = dataBuffer.getElemFloat(i) / 255.0f;
                float f8 = dataBuffer.getElemFloat(1 + i) / 255.0f;
                float f9 = dataBuffer.getElemFloat(2 + i) / 255.0f;
                float[] fArray = new float[3];
                if (f4 != f7 || f5 != f8 || f6 != f9) {
                    if (bl) {
                        System.out.println(f7 + " " + f8 + " " + f9);
                    }
                    float[] fArray2 = new float[]{f7, f8, f9};
                    fArray = this.cs.toRGB(fArray2);
                    fArray = fArray2;
                    f = fArray[0] * 255.0f;
                    f2 = fArray[1] * 255.0f;
                    f3 = fArray[2] * 255.0f;
                    f4 = f7;
                    f5 = f8;
                    f6 = f9;
                }
                byArray2[n4++] = (byte)f;
                byArray2[n4++] = (byte)f2;
                byArray2[n4++] = (byte)f3;
            }
            try {
                int[] nArray = new int[]{0, 1, 2};
                DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
                bufferedImage = new BufferedImage(n, n2, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
                LogWriter.writeLog("Exception " + exception + " with 24 bit RGB image");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }
}

