/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.printing;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import org.jpedal.PdfDecoder;
import org.jpedal.utils.LogWriter;

public class SilentPrint {
    private static boolean debugCode = true;
    private final String separator = System.getProperty("file.separator");
    private PdfDecoder decode_pdf = null;
    private int maxCopies = 5;
    private int copiesToPrint = 1;
    private int pageCount;
    private String printer = "FinePrint";
    private String tray = null;

    public SilentPrint(String string) {
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeAndPrintFile(string);
        } else {
            String[] stringArray = null;
            File file = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                file = new File(string);
                if (!file.isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray = file.list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray.length;
            int n = 0;
            while ((long)n < l) {
                if (stringArray[n].toLowerCase().endsWith(".pdf")) {
                    SilentPrint.logMessage(string + stringArray[n]);
                    this.decodeAndPrintFile(string + stringArray[n]);
                }
                ++n;
            }
        }
    }

    private void decodeAndPrintFile(String string) {
        try {
            SilentPrint.logMessage("Opening file :" + string + " to print.");
            this.decode_pdf = new PdfDecoder(true);
            this.decode_pdf.openPdfFile(string);
            this.pageCount = this.decode_pdf.getPageCount();
        }
        catch (Exception exception) {
            this.reportError("Exception " + exception + " in pdf code");
        }
        if (this.decode_pdf.isEncrypted() && !this.decode_pdf.isExtractionAllowed()) {
            SilentPrint.logMessage("Encrypted settings");
        } else {
            this.printAllCopies();
        }
        this.decode_pdf.closePdfFile();
    }

    private final void printAllCopies() {
        for (int i = 0; i < this.copiesToPrint; ++i) {
            SilentPrint.logMessage("========================");
            SilentPrint.logMessage("\nPrinting copy " + (i + 1));
            SilentPrint.logMessage("========================");
            this.printPages();
        }
    }

    private void printPages() {
        try {
            int n;
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = printerJob.defaultPage();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
            boolean bl = false;
            int n2 = printServiceArray.length;
            for (n = 0; n < n2; ++n) {
                if (printServiceArray[n].getName().indexOf(this.printer) == -1) continue;
                printerJob.setPrintService(printServiceArray[n]);
                n = n2;
                bl = true;
            }
            if (!bl) {
                String string = "";
                for (int i = 0; i < n2; ++i) {
                    string = string + printServiceArray[i].getName() + ",";
                }
                this.reportError("Printer " + this.printer + " not supported. Options=" + string);
            } else {
                if (this.tray != null) {
                    Class<?>[] classArray;
                    n = printerJob.getPrintService().isAttributeCategorySupported(Media.class) ? 1 : 0;
                    if (n != 0) {
                        classArray = new Hashtable();
                        Class clazz = Media.class;
                        Object object = printerJob.getPrintService().getSupportedAttributeValues(clazz, null, null);
                        if (object == null) {
                            SilentPrint.logMessage("Attribute " + clazz + " not supported");
                        } else if (object.getClass().isArray()) {
                            for (int i = 0; i < Array.getLength(object); ++i) {
                                Object object2 = Array.get(object, i);
                                classArray.put(object2.toString(), object2);
                                SilentPrint.logMessage("Atribute values " + object2.toString());
                            }
                        }
                        Object v = classArray.get(this.tray);
                        if (v != null) {
                            hashPrintRequestAttributeSet.add((Attribute)v);
                        }
                    } else {
                        SilentPrint.logMessage("Tray " + this.tray + " not implemented");
                        SilentPrint.logMessage("Atributes implemented are ");
                        classArray = printerJob.getPrintService().getSupportedAttributeCategories();
                        for (int i = 0; i < classArray.length; ++i) {
                            SilentPrint.logMessage(">>" + classArray[i].getName());
                        }
                    }
                }
                if (debugCode) {
                    Attribute[] attributeArray = hashPrintRequestAttributeSet.toArray();
                    int n3 = attributeArray.length;
                    for (int i = 0; i < n3; ++i) {
                        SilentPrint.logMessage(i + " " + attributeArray[i].getName() + " " + attributeArray[i].toString());
                    }
                }
                Paper paper = new Paper();
                paper.setSize(595.0, 842.0);
                paper.setImageableArea(0.0, 0.0, 595.0, 842.0);
                pageFormat.setPaper(paper);
                printerJob.setCopies(1);
                this.decode_pdf.setPrintAutoRotateAndCenter(true);
                this.decode_pdf.setPageFormat(pageFormat);
                this.decode_pdf.setPagePrintRange(1, this.decode_pdf.getPageCount());
                printerJob.setPageable(this.decode_pdf);
                printerJob.print();
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " printing");
        }
        catch (Error error) {
            LogWriter.writeLog("Error " + error + " printing");
        }
    }

    private static void logMessage(String string) {
        if (debugCode) {
            System.out.println(string);
            LogWriter.writeLog(string);
        }
    }

    private void reportError(String string) {
        System.err.println(string);
        LogWriter.writeLog(string);
    }

    public static void main(String[] stringArray) {
        SilentPrint.logMessage("Simple demo to print pages");
        if (stringArray.length != 1) {
            SilentPrint.logMessage("File name or directory must be supplied");
        }
        String string = stringArray[0];
        SilentPrint.logMessage("File :" + string);
        File file = new File(string);
        if (!file.exists()) {
            SilentPrint.logMessage("File " + string + " not found");
        }
        SilentPrint silentPrint = new SilentPrint(string);
    }
}

