/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

class ColorHistogramWindow
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner {
    static final int WIN_WIDTH = 300;
    static final int WIN_HEIGHT = 410;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 80;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    protected int[][] histogram;
    protected Rectangle[] frame = new Rectangle[3];
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Button log;
    protected Label value;
    protected Label count;
    protected int decimalPlaces;
    protected int digits;
    protected int plotScale = 1;
    protected boolean logScale;
    public static int nBins = 256;
    private byte[] mask;
    private int width;
    private int height = 1;
    protected int[] histMin = new int[3];
    protected int[] histMax = new int[3];
    protected double[] histMean = new double[3];
    protected int[] histMode = new int[3];
    protected int[] histModeCnt = new int[3];
    protected double[] histStdev = new double[3];
    protected ColorStats stats;

    public ColorHistogramWindow(ImagePlus imp) {
        super(NewImage.createRGBImage((String)("Histogram of " + imp.getShortTitle()), (int)300, (int)410, (int)1, (int)4));
        ImageProcessor ipmask = imp.getMask();
        boolean isnull = ipmask == null;
        this.mask = !isnull ? (byte[])ipmask.getPixels() : null;
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        this.showHistogram(imp, nBins, 0.0, 0.0);
        this.printResults();
    }

    public void setup() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button("List");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.copy = new Button("Copy");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        Panel valueAndCount = new Panel();
        valueAndCount.setLayout(new GridLayout(2, 1));
        this.value = new Label("                  ");
        this.value.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.value);
        this.count = new Label("                  ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.count);
        buttons.add(valueAndCount);
        this.add(buttons);
        this.pack();
    }

    public void showHistogram(ImagePlus imp, int bins, double histMin, double histMax) {
        Rectangle rect;
        this.setup();
        try {
            rect = imp.getRoi().getBoundingRect();
        }
        catch (NullPointerException e) {
            rect = new Rectangle(0, 0, this.width, this.height);
        }
        ColorProcessor cp = (ColorProcessor)imp.getProcessor();
        this.stats = this.mask != null ? new ColorStats(cp, this.mask, rect) : new ColorStats(cp, rect);
        this.histMean = this.stats.getMean();
        this.histMode = this.stats.getMode();
        this.histModeCnt = this.stats.getModeCnt();
        this.histStdev = this.stats.getStdev();
        this.histogram = this.stats.getHistogram();
        ImageProcessor ip = this.imp.getProcessor();
        this.drawHistogram(ip);
        this.imp.updateAndDraw();
    }

    protected void drawHistogram(ImageProcessor ip) {
        this.decimalPlaces = Analyzer.getPrecision();
        ip.setColor(Color.black);
        ip.setLineWidth(1);
        int offset = 0;
        int delta = 10;
        this.drawPlot(0, offset, ip);
        int x = 21;
        int y = 92;
        this.drawUnscaledColorBar(0, ip, x - 1, y, 256, 12);
        y += 12;
        int cheight = 94 + delta;
        this.drawPlot(1, offset += cheight, ip);
        x = 21;
        y = 92;
        this.drawUnscaledColorBar(1, ip, x - 1, y + offset, 256, 12);
        y += 12;
        this.drawPlot(2, offset += cheight, ip);
        x = 21;
        y = 92;
        this.drawUnscaledColorBar(2, ip, x - 1, y + offset, 256, 12);
        this.drawText(ip, x, (y += 27) + offset);
    }

    protected void drawUnscaledColorBar(int color, ImageProcessor ip, int x, int y, int width, int height) {
        ColorProcessor bar = null;
        if (ip instanceof ColorProcessor) {
            bar = new ColorProcessor(width, height);
            for (int i = 0; i < 256; ++i) {
                switch (color) {
                    case 0: {
                        bar.setColor(new Color(i & 0xFF, 0, 0));
                        break;
                    }
                    case 1: {
                        bar.setColor(new Color(0, i & 0xFF, 0));
                        break;
                    }
                    case 2: {
                        bar.setColor(new Color(0, 0, i & 0xFF));
                    }
                }
                bar.moveTo(i, 0);
                bar.lineTo(i, height);
            }
            ip.insert((ImageProcessor)bar, x, y);
            ip.setColor(Color.black);
            ip.drawRect(x - 1, y, width + 2, height);
        }
    }

    public void printResults() {
        ResultsTable rt = Analyzer.getResultsTable();
        if (rt == null) {
            rt = new ResultsTable();
            Analyzer.setResultsTable((ResultsTable)rt);
        }
        IJ.run((String)"Clear Results", (String)"");
        String[] channels = new String[]{"red", "green", "blue"};
        for (int i = 0; i < 3; ++i) {
            rt.incrementCounter();
            rt.addValue("channel", channels[i]);
            rt.addValue("mean", this.histMean[i]);
            rt.addValue("mode", (double)this.histModeCnt[i]);
            rt.addValue("std.dev.", this.histStdev[i]);
        }
        rt.show("Results");
    }

    public void drawPlot(int what, int offset, ImageProcessor ip) {
        int mode = this.histMode[what];
        int YM = 10 + offset;
        this.frame[what] = new Rectangle(20, YM, 256, 80);
        ip.drawRect(this.frame[what].x - 1, this.frame[what].y, this.frame[what].width + 2, this.frame[what].height + 1);
        for (int i = 0; i < 256; ++i) {
            int y = 80 * this.histogram[what][i] / mode;
            if (y > 80) {
                y = 80;
            }
            ip.drawLine(i + 20, YM + 80, i + 20, YM + 80 - y);
        }
    }

    int getWidth(double d, ImageProcessor ip) {
        return ip.getStringWidth(IJ.d2s((double)d, (int)0));
    }

    void drawText(ImageProcessor ip, int x, int y) {
        ip.setFont(new Font("SansSerif", 0, 12));
        ip.setAntialiasedText(true);
        ip.drawString(IJ.d2s((double)0.0, (int)0), x - 4, y);
        ip.drawString(IJ.d2s((double)255.0, (int)0), x + 256 - this.getWidth(256.0, ip) + 10, y);
        int col1 = 20;
        int col2 = 115;
        int col3 = col2 + 85;
        int row1 = y + 25;
        int row2 = row1 + 15;
        int row3 = row2 + 15;
        int row4 = row3 + 15;
        ip.drawString("Count: " + this.stats.getHistcount(), col1, row1);
        ip.drawString("rMean: " + IJ.d2s((double)this.histMean[0], (int)2), col1, row2);
        ip.drawString("rSD: " + IJ.d2s((double)this.histStdev[0], (int)2), col2, row2);
        ip.drawString("gMean: " + IJ.d2s((double)this.histMean[1], (int)2), col1, row3);
        ip.drawString("gSD: " + IJ.d2s((double)this.histStdev[1], (int)2), col2, row3);
        ip.drawString("bMean: " + IJ.d2s((double)this.histMean[2], (int)2), col1, row4);
        ip.drawString("bSD: " + IJ.d2s((double)this.histStdev[2], (int)2), col2, row4);
        ip.drawString("rMode: " + IJ.d2s((double)this.histModeCnt[0], (int)0), col3, row2);
        ip.drawString("gMode: " + IJ.d2s((double)this.histModeCnt[1], (int)0), col3, row3);
        ip.drawString("bMode: " + IJ.d2s((double)this.histModeCnt[2], (int)0), col3, row4);
    }

    void showList() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 256; ++i) {
            sb.append(i + "\t" + this.histogram[0][i] + "\t" + this.histogram[1][i] + "\t" + this.histogram[2][i] + "\n");
        }
        TextWindow tw = new TextWindow(this.getTitle(), "bin\tred\tgreen\tblue", sb.toString(), 200, 400);
    }

    void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error((String)"Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus((String)"Copying histogram values...");
        CharArrayWriter aw = new CharArrayWriter(1024);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < 256; ++i) {
            pw.print(i + "\t" + this.histogram[0][i] + "\t" + this.histogram[1][i] + "\t" + this.histogram[2][i] + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus((String)(text.length() + " characters copied to Clipboard"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.list) {
            this.showList();
        } else if (b == this.copy) {
            this.copyToClipboard();
        }
    }

    public void mouseMoved(int x, int y) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null) {
            if (this.frame[0].contains(new Point(x, y))) {
                if ((x -= this.frame[0].x) > 255) {
                    x = 255;
                }
                int index = (int)((double)x * (double)this.histogram[0].length / 256.0);
                this.value.setText("  Value: " + index);
                this.count.setText("  Count: " + this.histogram[0][index]);
            } else if (this.frame[1].contains(new Point(x, y))) {
                if ((x -= this.frame[1].x) > 255) {
                    x = 255;
                }
                int index = (int)((double)x * (double)this.histogram[1].length / 256.0);
                this.value.setText("  Value: " + index);
                this.count.setText("  Count: " + this.histogram[1][index]);
            } else if (this.frame[2].contains(new Point(x, y))) {
                if ((x -= this.frame[2].x) > 255) {
                    x = 255;
                }
                int index = (int)((double)x * (double)this.histogram[2].length / 256.0);
                this.value.setText("  Value: " + index);
                this.count.setText("  Count: " + this.histogram[2][index]);
            } else {
                this.value.setText("");
                this.count.setText("");
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

