/*
 * Decompiled with CFR 0.152.
 */
package fiji;

import fiji.debugging.Object_Inspector;
import java.io.File;
import net.imagej.patcher.LegacyEnvironment;
import net.imagej.patcher.LegacyInjector;

public class Debug {
    public static void show(Object object) {
        Object_Inspector.openFrame("" + object, object);
    }

    public static Object get(Object object, String fieldName) {
        return Object_Inspector.get(object, fieldName);
    }

    public static void run(String plugin, String parameters) {
        Debug.runFilter(null, plugin, parameters);
    }

    public static void runFilter(String imagePath, String plugin, String parameters) {
        Debug.runFilter(imagePath, plugin, parameters, false);
    }

    public static void runFilter(String imagePath, String plugin, String parameters, boolean headless) {
        try {
            System.setProperty("ij1.plugin.dirs", "/non-existing/");
            LegacyEnvironment ij1 = new LegacyEnvironment(null, headless);
            ij1.addPluginClasspath(Thread.currentThread().getContextClassLoader());
            if (!headless) {
                ij1.main(new String[0]);
            }
            if (imagePath != null) {
                File file = new File(imagePath);
                if (!file.isAbsolute()) {
                    imagePath = file.getAbsolutePath();
                }
                ij1.runMacro("open('" + imagePath + "');", "");
            }
            ij1.run(plugin, parameters);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object runPlugIn(String className, String arg, boolean headless) {
        try {
            System.setProperty("ij1.plugin.dirs", "/non-existing/");
            LegacyEnvironment ij1 = new LegacyEnvironment(null, headless);
            ij1.addPluginClasspath(Thread.currentThread().getContextClassLoader());
            if (!headless) {
                ij1.main(new String[0]);
            }
            return ij1.runPlugIn(className, arg);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LegacyInjector.preinit();
    }
}

