/*
 * Decompiled with CFR 0.152.
 */
package fiji.util.gui;

import fiji.util.gui.OverlayedImageCanvas;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public abstract class AbstractAnnotation
implements OverlayedImageCanvas.Overlay {
    protected Composite composite = AlphaComposite.getInstance(9);
    protected Color color = Color.YELLOW;
    protected Stroke stroke = new BasicStroke(1.0f);

    @Override
    public void paint(Graphics g, int x, int y, double magnification) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform originalTransform = g2d.getTransform();
        Composite originalComposite = g2d.getComposite();
        Stroke originalStroke = g2d.getStroke();
        Color originalColor = g2d.getColor();
        g2d.setStroke(this.stroke);
        AffineTransform at = new AffineTransform();
        at.scale(magnification, magnification);
        at.translate(-x, -y);
        at.concatenate(originalTransform);
        g2d.setTransform(at);
        g2d.setComposite(this.composite);
        g2d.setColor(this.color);
        this.draw(g2d);
        g2d.setTransform(originalTransform);
        g2d.setComposite(originalComposite);
        g2d.setStroke(originalStroke);
        g2d.setColor(originalColor);
    }

    @Override
    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public abstract void draw(Graphics2D var1);
}

