/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.launcher;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Config {
    private Config() {
    }

    public static Map<String, String> load(File file) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Files.readAllLines(file.toPath()).forEach(line -> {
            int equals = line.indexOf(61);
            if (equals >= 0) {
                String key = line.substring(0, equals);
                String val = line.substring(equals + 1);
                map.put(key, val);
            }
        });
        return map;
    }

    public static void save(File file, Map<String, String> config) throws IOException {
        try (PrintWriter pw = new PrintWriter(new FileWriter(file));){
            for (Map.Entry<String, String> entry : config.entrySet()) {
                pw.println(entry.getKey() + "=" + entry.getValue());
            }
        }
    }

    public static void update(File file, Map<String, String> props) throws IOException {
        Map<String, String> config;
        if (file.isFile()) {
            config = Config.load(file);
            config.putAll(props);
        } else {
            config = props;
        }
        Config.save(file, config);
    }

    public static void update(File file, String key, String val) throws IOException {
        Config.update(file, Collections.singletonMap(key, val));
    }
}

