/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import org.scijava.launcher.ClassLoaders;
import org.scijava.launcher.LookAndFeel;

public class Splash {
    private static final int PROGRESS_MAX = 10000;
    private static Object splashWindow;
    private static Object progressBar;

    public static void show() {
        Splash.show(true);
    }

    public static void show(boolean autoclose) {
        Splash.show(null, autoclose);
    }

    public static void show(String logoPath) {
        Splash.show(logoPath, true);
    }

    public static void show(String logoPath, boolean autoclose) {
        JLabel logoImage;
        if (Boolean.getBoolean("java.awt.headless")) {
            return;
        }
        LookAndFeel.init();
        if (logoPath == null) {
            logoPath = System.getProperty("scijava.app.splash-image");
        }
        JWindow window = new JWindow();
        splashWindow = window;
        if (logoPath == null) {
            logoImage = null;
        } else {
            URL logoURL = ClassLoaders.loadResource(Splash.class, logoPath);
            ImageIcon imageIcon = new ImageIcon(logoURL);
            logoImage = new JLabel(imageIcon);
        }
        JProgressBar bar = new JProgressBar();
        bar.setMaximum(10000);
        progressBar = bar;
        bar.setStringPainted(true);
        String appName = System.getProperty("scijava.app.name");
        if (appName == null) {
            appName = "application";
        }
        bar.setString("Starting " + appName + "...");
        JPanel pane = new JPanel();
        pane.setOpaque(false);
        pane.setLayout(new BorderLayout());
        if (logoImage != null) {
            pane.add((Component)logoImage, "Center");
        }
        pane.add((Component)bar, "South");
        window.setContentPane(pane);
        window.pack();
        window.setAlwaysOnTop(true);
        window.setLocationRelativeTo(null);
        window.setBackground(new Color(0, 0, 0, 0));
        window.setVisible(true);
        if (autoclose) {
            Splash.startSplashAutocloseThread();
        }
    }

    public static void update(String message) {
        Splash.update(message, Double.NaN);
    }

    public static void update(double progress) {
        Splash.update(null, progress);
    }

    public static void update(String message, double progress) {
        Runnable updater = () -> {
            JProgressBar jpBar = (JProgressBar)progressBar;
            if (jpBar == null) {
                return;
            }
            if (message != null) {
                jpBar.setString(message);
            }
            if (!Double.isNaN(progress)) {
                jpBar.setValue((int)(progress * 10000.0));
            }
        };
        if (EventQueue.isDispatchThread()) {
            updater.run();
        } else {
            EventQueue.invokeLater(updater);
        }
    }

    public static void hide() {
        if (splashWindow == null) {
            return;
        }
        ((Window)splashWindow).dispose();
        splashWindow = null;
        progressBar = null;
    }

    private static void startSplashAutocloseThread() {
        Thread thread = new Thread(() -> {
            block2: while (true) {
                Window[] windows;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (splashWindow == null) {
                    return;
                }
                Window[] windowArray = windows = Window.getWindows();
                int n = windowArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block2;
                    Window win = windowArray[n2];
                    if (win.isVisible() && win != splashWindow) {
                        win.requestFocusInWindow();
                        Splash.hide();
                        return;
                    }
                    ++n2;
                }
                break;
            }
        }, "Splash-Monitor");
        thread.setDaemon(true);
        thread.start();
    }
}

