/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.ArrayList;
import javax.swing.ImageIcon;

public class Panel {
    private int x;
    private int y;
    private int h;
    private int defaultHeight;
    public static final int TITLEBAR_DEFAULT_HEIGHT = 21;
    private ArrayList<Integer> separatorHeights;
    private String title;
    private boolean expanded;
    private boolean visible;
    private ArrayList<Component> components;
    public static final Image VISIBLE_BUTTON = new ImageIcon(Panel.class.getResource("/icons/opened_panel.png")).getImage();
    public static final Image HIDDEN_BUTTON = new ImageIcon(Panel.class.getResource("/icons/closed_panel.png")).getImage();

    private void drawHeader(String titleText, int x, int y, Graphics g) {
        g.setColor(new Color(225, 225, 225));
        g.fillRect(0, y, 225, 20);
        g.setColor(new Color(100, 100, 100));
        g.drawRect(0, y, 225, 20);
        g.setColor(new Color(180, 180, 180));
        g.drawLine(0, y + 21, 225, y + 21);
        g.setColor(Color.BLACK);
        g.drawString(titleText, x + 7, y + 16);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.expanded) {
            g.drawImage(VISIBLE_BUTTON, x + 225 - 18, y + 3, 15, 15, null);
        } else {
            g.drawImage(HIDDEN_BUTTON, x + 225 - 18, y + 3, 15, 15, null);
        }
    }

    public Panel(int x, int y, int h, String title) {
        this.x = x;
        this.y = y;
        this.h = this.defaultHeight = h;
        this.title = title;
        this.expanded = true;
        this.visible = true;
        this.components = new ArrayList();
        this.separatorHeights = new ArrayList();
    }

    public Panel(int h, String title) {
        this(0, 0, h, title);
    }

    public void draw(Graphics g) {
        if (!this.visible) {
            return;
        }
        this.drawHeader(this.title, this.x, this.y, g);
        if (this.expanded) {
            for (int y : this.separatorHeights) {
                g.setColor(new Color(245, 245, 245));
                g.drawLine(0, y, 225, y);
                g.setColor(Color.GRAY);
                g.drawLine(0, y + 1, 225, y + 1);
            }
        }
        g.setColor(Color.BLACK);
    }

    public void toggleExpanded() {
        this.expanded = !this.expanded;
        for (Component c : this.components) {
            c.setVisible(this.expanded);
        }
        this.h = !this.expanded ? 21 : this.defaultHeight;
    }

    public void hide() {
        this.visible = false;
        for (Component c : this.components) {
            c.setVisible(this.visible);
        }
        this.h = 0;
    }

    public void show() {
        this.visible = true;
        for (Component c : this.components) {
            c.setVisible(this.visible);
        }
        this.h = this.defaultHeight;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void addSeparator(int y) {
        this.separatorHeights.add(y + this.y);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        for (int i = 0; i < this.separatorHeights.size(); ++i) {
            this.separatorHeights.set(i, y + this.separatorHeights.get(i) - this.y);
        }
        for (Component c : this.components) {
            c.setBounds(this.x + c.getX(), y + c.getY() - this.y, c.getWidth(), c.getHeight());
        }
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getH() {
        return this.h;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.toggleExpanded();
        }
    }

    public void addComponent(Component c) {
        c.setBounds(this.x + c.getX(), this.y + c.getY(), c.getWidth(), c.getHeight());
        c.setVisible(this.expanded);
        this.components.add(c);
    }

    public boolean isPointOnToggle(Point p) {
        return p.getX() > (double)this.x && p.getY() > (double)this.y && p.getX() <= (double)(this.x + 225) && p.getY() < (double)(this.y + 20);
    }
}

