/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import ij.IJ;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.imagej.patcher.LegacyHooks;

public class EssentialLegacyHooks
extends LegacyHooks {
    @Override
    public void error(Throwable t) {
        IJ.handleException((Throwable)t);
    }

    @Override
    public void initialized() {
        this.runInitializer();
    }

    private void runInitializer() {
        String property = System.getProperty("ij1.patcher.initializer");
        try {
            Class<?> runClass;
            ClassLoader loader = IJ.getClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
            if (property != null) {
                runClass = loader.loadClass(property);
            } else {
                try {
                    runClass = loader.loadClass("net.imagej.legacy.plugin.LegacyInitializer");
                }
                catch (ClassNotFoundException e) {
                    runClass = loader.loadClass("imagej.legacy.plugin.LegacyInitializer");
                }
            }
            Runnable run = (Runnable)runClass.newInstance();
            run.run();
        }
        catch (ClassNotFoundException loader) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static ClassLoader missingSubdirs(ClassLoader loader, boolean addPluginsDir) {
        if (loader == null || !(loader instanceof URLClassLoader)) {
            return null;
        }
        URLClassLoader classLoader = (URLClassLoader)loader;
        LinkedHashSet<File> directories = new LinkedHashSet<File>();
        for (URL url : classLoader.getURLs()) {
            File dir;
            if (!"file".equals(url.getProtocol()) || !(dir = new File(url.getPath())).isDirectory() || EssentialLegacyHooks.isBuildDirectory(dir)) continue;
            directories.add(dir);
        }
        LinkedHashSet<File> missing = new LinkedHashSet<File>();
        if (addPluginsDir) {
            File plugins;
            String pluginsDir = IJ.getDirectory((String)"plugins");
            if (pluginsDir == null) {
                pluginsDir = System.getProperty("plugins.dir");
            }
            if (pluginsDir != null && !directories.contains(plugins = new File(pluginsDir))) {
                directories.add(plugins);
                missing.add(plugins);
            }
        }
        try {
            for (File dir : directories) {
                EssentialLegacyHooks.missingSubdirectories(dir, directories, missing);
            }
            if (missing.isEmpty()) {
                return null;
            }
            URL[] urls = new URL[missing.size()];
            int i = 0;
            for (File dir : missing) {
                urls[i++] = dir.toURI().toURL();
            }
            return new URLClassLoader(urls, loader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isBuildDirectory(File dir) {
        String[] buildDirs = new String[]{"target", "build", "bin"};
        return Arrays.asList(buildDirs).contains(dir.getParentFile().getName());
    }

    private static boolean missingSubdirectories(File dir, Set<File> already, Set<File> missing) {
        boolean containsClassFiles = false;
        for (File sub : dir.listFiles()) {
            if (sub.isDirectory()) {
                if (already.contains(sub) || missing.contains(sub) || !EssentialLegacyHooks.missingSubdirectories(sub, already, missing)) continue;
                try {
                    containsClassFiles = true;
                    missing.add(sub);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            if (!sub.getName().endsWith(".class")) continue;
            containsClassFiles = true;
        }
        return containsClassFiles;
    }

    @Override
    public Object interceptRunPlugIn(String className, String arg) {
        if ("org.scijava.Context".equals(className)) {
            try {
                Class<?> contextClass = IJ.getClassLoader().loadClass(className);
                try {
                    return contextClass.newInstance();
                }
                catch (Throwable t) {
                    Class<?> legacyServiceClass;
                    t.printStackTrace();
                    try {
                        legacyServiceClass = IJ.getClassLoader().loadClass("net.imagej.legacy.DefaultLegacyService");
                    }
                    catch (Throwable t2) {
                        try {
                            legacyServiceClass = IJ.getClassLoader().loadClass("net.imagej.legacy.LegacyService");
                        }
                        catch (Throwable t3) {
                            legacyServiceClass = IJ.getClassLoader().loadClass("imagej.legacy.DefaultLegacyService");
                        }
                    }
                    Constructor<?> ctor = contextClass.getConstructor(Class[].class);
                    return ctor.newInstance(new Object[]{new Class[]{legacyServiceClass}});
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.err.println("Giving up to create a SciJava Context!");
            }
        }
        return null;
    }
}

