/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.miginfocom.swing.MigLayout;
import sc.fiji.labkit.ui.BasicLabelingComponent;
import sc.fiji.labkit.ui.DefaultExtensible;
import sc.fiji.labkit.ui.actions.LabelEditAction;
import sc.fiji.labkit.ui.models.ColoredLabelsModel;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.panel.ImageInfoPanel;
import sc.fiji.labkit.ui.panel.LabelPanel;

public class LabelingComponent
extends JPanel
implements AutoCloseable {
    private final BasicLabelingComponent labelingComponent;

    public LabelingComponent(JFrame dialogBoxOwner, ImageLabelingModel model) {
        this.labelingComponent = new BasicLabelingComponent(dialogBoxOwner, model);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][grow]"));
        leftPanel.add((Component)ImageInfoPanel.newFramedImageInfoPanel(model, this.labelingComponent), "grow, wrap");
        DefaultExtensible extensible = new DefaultExtensible(null, dialogBoxOwner);
        new LabelEditAction(extensible, false, new ColoredLabelsModel(model));
        leftPanel.add((Component)LabelPanel.newFramedLabelPanel(model, extensible, false), "grow");
        this.setLayout(new BorderLayout());
        this.add(this.initSplitPane(leftPanel, this.labelingComponent));
    }

    private JSplitPane initSplitPane(JComponent left, JComponent right) {
        JSplitPane panel = new JSplitPane();
        panel.setSize(100, 100);
        panel.setOneTouchExpandable(true);
        panel.setLeftComponent(left);
        panel.setRightComponent(right);
        return panel;
    }

    @Deprecated
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void close() {
        this.labelingComponent.close();
    }
}

