/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.actions;

import javax.swing.filechooser.FileNameExtensionFilter;
import org.scijava.Context;
import sc.fiji.labkit.ui.Extensible;
import sc.fiji.labkit.ui.actions.AbstractFileIoAction;
import sc.fiji.labkit.ui.models.SegmentationItem;
import sc.fiji.labkit.ui.models.SegmenterListModel;
import sc.fiji.labkit.ui.segmentation.SegmentationPlugin;
import sc.fiji.labkit.ui.segmentation.SegmentationPluginService;

public class ClassifierIoAction
extends AbstractFileIoAction {
    private final SegmenterListModel segmenterListModel;
    private final Context context;

    public ClassifierIoAction(Extensible extensible, SegmenterListModel selectedSegmenter) {
        super(extensible, new FileNameExtensionFilter("Classifier", "classifier"));
        this.context = extensible.context();
        this.segmenterListModel = selectedSegmenter;
        this.initSaveAction(SegmentationItem.SEGMENTER_MENU, "Save Classifier ...", 101.0f, this::save, "");
        this.initOpenAction(SegmentationItem.SEGMENTER_MENU, "Open Classifier ...", 100.0f, this::open, "");
    }

    private void save(SegmentationItem item, String filename) {
        item.saveModel(filename);
    }

    private void open(SegmentationItem item, String filename) {
        item = this.addMatchingSegmentationItem(filename);
        item.openModel(filename);
        this.segmenterListModel.selectedSegmenter().set(item);
    }

    private SegmentationItem addMatchingSegmentationItem(String filename) {
        SegmentationPluginService pluginService = (SegmentationPluginService)this.context.service(SegmentationPluginService.class);
        for (SegmentationPlugin plugin : pluginService.getSegmentationPlugins()) {
            if (!plugin.canOpenFile(filename)) continue;
            return this.segmenterListModel.addSegmenter(plugin);
        }
        throw new IllegalArgumentException("No suitable plugin found for opening: \"" + filename + "\"");
    }
}

