/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import java.util.AbstractList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.imagej.ImgPlus;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.scijava.Context;
import sc.fiji.labkit.ui.inputimage.InputImage;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.ExtensionPoints;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.models.SegmentationModel;
import sc.fiji.labkit.ui.models.SegmenterListModel;
import sc.fiji.labkit.ui.segmentation.SegmentationTool;
import sc.fiji.labkit.ui.segmentation.Segmenter;
import sc.fiji.labkit.ui.utils.progress.DummyProgressWriter;

public class DefaultSegmentationModel
implements SegmentationModel {
    private final Context context;
    private final ImageLabelingModel imageLabelingModel;
    private final SegmenterListModel segmenterList;
    private final ExtensionPoints extensionPoints = new ExtensionPoints();

    public DefaultSegmentationModel(Context context, InputImage inputImage) {
        this.context = context;
        this.imageLabelingModel = new ImageLabelingModel(inputImage);
        this.segmenterList = new SegmenterListModel(context, this.extensionPoints);
        this.segmenterList().trainingData().set(new SingletonTrainingData(this.imageLabelingModel));
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public ImageLabelingModel imageLabelingModel() {
        return this.imageLabelingModel;
    }

    @Override
    public SegmenterListModel segmenterList() {
        return this.segmenterList;
    }

    public ExtensionPoints extensionPoints() {
        return this.extensionPoints;
    }

    @Deprecated
    public <T extends IntegerType<T> & NativeType<T>> List<RandomAccessibleInterval<T>> getSegmentations(T type) {
        ImgPlus<?> image = this.imageLabelingModel().imageForSegmentation().get();
        Stream<Segmenter> trainedSegmenters = this.getTrainedSegmenters();
        return trainedSegmenters.map(segmenter -> {
            SegmentationTool segmentationTool = new SegmentationTool((Segmenter)segmenter);
            segmentationTool.setProgressWriter(new DummyProgressWriter());
            return segmentationTool.segment(image, type);
        }).collect(Collectors.toList());
    }

    @Deprecated
    public List<RandomAccessibleInterval<FloatType>> getPredictions() {
        ImgPlus<?> image = this.imageLabelingModel().imageForSegmentation().get();
        Stream<Segmenter> trainedSegmenters = this.getTrainedSegmenters();
        return trainedSegmenters.map(segmenter -> {
            SegmentationTool segmentationTool = new SegmentationTool((Segmenter)segmenter);
            segmentationTool.setProgressWriter(new DummyProgressWriter());
            return segmentationTool.probabilityMap(image);
        }).collect(Collectors.toList());
    }

    public boolean isTrained() {
        return this.getTrainedSegmenters().findAny().isPresent();
    }

    private Stream<Segmenter> getTrainedSegmenters() {
        return this.segmenterList.segmenters().get().stream().filter(Segmenter::isTrained).map(x -> x);
    }

    private class SingletonTrainingData
    extends AbstractList<Pair<ImgPlus<?>, Labeling>> {
        private final ImageLabelingModel imageLabelingModel;

        public SingletonTrainingData(ImageLabelingModel imageLabelingModel) {
            this.imageLabelingModel = imageLabelingModel;
        }

        @Override
        public Pair<ImgPlus<?>, Labeling> get(int index) {
            ImgPlus<?> image = this.imageLabelingModel.imageForSegmentation().get();
            Labeling labeling = this.imageLabelingModel.labeling().get();
            return new ValuePair(image, (Object)labeling);
        }

        @Override
        public int size() {
            return 1;
        }
    }
}

