/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import java.util.ArrayList;
import java.util.List;
import net.imagej.ImgPlus;
import net.imglib2.util.Pair;
import org.scijava.Context;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.DefaultHolder;
import sc.fiji.labkit.ui.models.ExtensionPoints;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.SegmentationItem;
import sc.fiji.labkit.ui.segmentation.SegmentationPlugin;

public class SegmenterListModel {
    private final Context context;
    private final ExtensionPoints extensionPoints;
    private final Holder<List<SegmentationItem>> segmenters = new DefaultHolder(new ArrayList());
    private final Holder<SegmentationItem> selectedSegmenter = new DefaultHolder<Object>(null);
    private final Holder<Boolean> segmentationVisibility = new DefaultHolder<Boolean>(true);
    private final Holder<List<Pair<ImgPlus<?>, Labeling>>> trainingData = new DefaultHolder<Object>(null);

    public SegmenterListModel(Context context, ExtensionPoints extensionPoints) {
        this.context = context;
        this.extensionPoints = extensionPoints;
        this.segmenters.notifier().addListener(() -> {
            if (!this.segmenters.get().contains(this.selectedSegmenter.get())) {
                this.selectedSegmenter.set(null);
            }
        });
    }

    public Holder<List<SegmentationItem>> segmenters() {
        return this.segmenters;
    }

    public Holder<SegmentationItem> selectedSegmenter() {
        return this.selectedSegmenter;
    }

    public SegmentationItem addSegmenter(SegmentationPlugin plugin) {
        SegmentationItem segmentationItem = new SegmentationItem(plugin, this.extensionPoints);
        this.segmenters.get().add(segmentationItem);
        this.segmenters.notifier().notifyListeners();
        return segmentationItem;
    }

    public void remove(SegmentationItem item) {
        this.segmenters.get().remove(item);
        this.segmenters.notifier().notifyListeners();
    }

    public Holder<Boolean> segmentationVisibility() {
        return this.segmentationVisibility;
    }

    public Context context() {
        return this.context;
    }

    public Holder<List<Pair<ImgPlus<?>, Labeling>>> trainingData() {
        return this.trainingData;
    }
}

