/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.plugin;

import bdv.export.ProgressWriter;
import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import net.imagej.Dataset;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.ui.LabkitFrame;
import sc.fiji.labkit.ui.inputimage.DatasetInputImage;
import sc.fiji.labkit.ui.inputimage.InputImage;
import sc.fiji.labkit.ui.inputimage.SpimDataInputException;
import sc.fiji.labkit.ui.inputimage.SpimDataInputImage;
import sc.fiji.labkit.ui.plugin.CziOpener;
import sc.fiji.labkit.ui.utils.progress.StatusServiceProgressWriter;

@Plugin(type=Command.class, menuPath="Plugins > Labkit > Open Image File With Labkit")
public class LabkitImportPlugin
implements Command {
    @Parameter
    private Context context;
    @Parameter
    private File file;

    public void run() {
        LabkitImportPlugin.run(this.context, this.file);
    }

    private static void run(Context context, File file) {
        try {
            StatusServiceProgressWriter progressWriter = new StatusServiceProgressWriter((StatusService)context.service(StatusService.class));
            InputImage image = LabkitImportPlugin.openImage(context, progressWriter, file);
            LabkitFrame.showForImage(context, image);
        }
        catch (SpimDataInputException e) {
            JOptionPane.showMessageDialog(null, "There was an error when opening: " + file + "\n\n" + e.getMessage(), "Problem", 0);
        }
    }

    private static InputImage openImage(Context context, ProgressWriter progressWriter, File file) {
        String filename = file.getAbsolutePath();
        if (filename.endsWith(".h5")) {
            filename = filename.replaceAll("\\.h5$", ".xml");
        }
        if (filename.endsWith(".czi")) {
            return new CziOpener(progressWriter).openWithDialog(file.getAbsolutePath());
        }
        if (filename.endsWith(".xml") || filename.endsWith(".ims")) {
            return SpimDataInputImage.openWithGuiForLevelSelection(filename);
        }
        try {
            Dataset dataset = ((DatasetIOService)context.service(DatasetIOService.class)).open((Location)new FileLocation(file));
            DatasetInputImage datasetInputImage = new DatasetInputImage(dataset);
            datasetInputImage.setDefaultLabelingFilename(filename + ".labeling");
            return datasetInputImage;
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Could not open the image file: " + file);
        }
    }

    public static void main(String ... args) {
        CommandService commandService = (CommandService)new Context().service(CommandService.class);
        commandService.run(LabkitImportPlugin.class, true, new Object[0]);
    }
}

