/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.LinearAxis;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.fill.Filter;
import net.imglib2.algorithm.fill.FloodFill;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.roi.IterableRegion;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.IntType;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.table.Column;
import org.scijava.table.DefaultColumn;
import org.scijava.table.DefaultGenericTable;
import org.scijava.table.DoubleColumn;
import org.scijava.table.Table;
import org.scijava.ui.UIService;
import sc.fiji.labkit.ui.Extensible;
import sc.fiji.labkit.ui.MenuBar;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.labeling.LabelingSerializer;
import sc.fiji.labkit.ui.models.LabelingModel;
import sc.fiji.labkit.ui.utils.sparse.SparseRandomAccessIntType;

@Plugin(type=Command.class, menuPath="Plugins > Segmentation > Measure Connected Components")
public class MeasureConnectedComponents
implements Command {
    @Parameter
    Context context;
    @Parameter(label="File containing labeling (*.labeling)")
    File labelingFile;
    @Parameter(label="calculate calibrated size")
    boolean calibratedSize = true;
    @Parameter(type=ItemIO.OUTPUT)
    Table<?, ?> table;

    public void run() {
        try {
            Labeling labeling = new LabelingSerializer(this.context).open(this.labelingFile.getAbsolutePath());
            this.table = MeasureConnectedComponents.createTable(labeling, this.calibratedSize);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addAction(Extensible extensible, LabelingModel model) {
        Runnable action = () -> {
            Table<?, ?> table = MeasureConnectedComponents.createTable(model.labeling().get(), true);
            ((UIService)extensible.context().service(UIService.class)).show(table);
        };
        extensible.addMenuItem(MenuBar.OTHERS_MENU, "Measure Connected Components ...", 3.0f, ignore -> action.run(), null, "");
    }

    private static Table<?, ?> createTable(Labeling labeling, boolean calibratedSize) {
        TableBuilder builder = new TableBuilder();
        builder.setPixelSize(labeling.axes());
        labeling.iterableRegions().forEach((label, mask) -> builder.add(label.name(), MeasureConnectedComponents.connectedComponetsSizes((IterableRegion<BitType>)mask)));
        return builder.getTable(calibratedSize);
    }

    static List<Long> connectedComponetsSizes(IterableRegion<BitType> region) {
        ArrayList<Long> sizes = new ArrayList<Long>();
        Cursor cursor = region.inside().cursor();
        SparseRandomAccessIntType visitedImage = new SparseRandomAccessIntType((Interval)region);
        RandomAccess<IntType> visited = visitedImage.randomAccess();
        int currentIndex = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            visited.setPosition((Localizable)cursor);
            if (((IntType)visited.get()).get() != 0) continue;
            long countBefore = visitedImage.sparsityPattern().inside().size();
            Filter filter = (current, seed) -> ((BitType)current.getA()).get() && ((IntType)current.getB()).get() == 0;
            FloodFill.fill(region, (RandomAccessible)visitedImage, (Localizable)cursor, (Type)new IntType(++currentIndex), (Shape)new DiamondShape(1L), (Filter)filter);
            long countAfter = visitedImage.sparsityPattern().inside().size();
            sizes.add(countAfter - countBefore);
        }
        return sizes;
    }

    private static class TableBuilder {
        Column<String> labels = new DefaultColumn(String.class, "label");
        Column<Integer> indices = new DefaultColumn(Integer.class, "connect component");
        Column<Long> number = new DefaultColumn(Long.class, "size in pixels");
        Column<Double> sizes = new DoubleColumn("size");
        private double pixelSize = 1.0;
        private String unit = "unknown";

        private TableBuilder() {
        }

        private void setPixelSize(List<CalibratedAxis> axes) {
            double pixelSize = 1.0;
            StringJoiner units = new StringJoiner("*");
            for (CalibratedAxis axis : axes) {
                if (axis instanceof LinearAxis) {
                    LinearAxis linear = (LinearAxis)axis;
                    pixelSize *= linear.scale();
                    units.add(linear.unit() == null ? "unknown" : linear.unit());
                    continue;
                }
                return;
            }
            this.pixelSize = pixelSize;
            this.unit = units.toString();
        }

        private void add(String label, List<Long> sizesInPixels) {
            int index = 0;
            for (Long size : sizesInPixels) {
                this.labels.add((Object)label);
                this.indices.add((Object)(++index));
                this.number.add((Object)size);
                this.sizes.add((Object)((double)size.longValue() * this.pixelSize));
            }
        }

        public Table<?, ?> getTable(boolean calibratedSize) {
            DefaultGenericTable table = new DefaultGenericTable();
            table.add(this.labels);
            table.add(this.indices);
            table.add(this.number);
            if (calibratedSize) {
                this.sizes.setHeader("size in " + this.unit);
                table.add(this.sizes);
            }
            return table;
        }
    }
}

