/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.segmentation;

import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JOptionPane;
import net.imagej.ImgPlus;
import net.imglib2.util.Pair;
import sc.fiji.labkit.ui.Extensible;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.SegmentationItem;
import sc.fiji.labkit.ui.models.SegmenterListModel;
import sc.fiji.labkit.ui.panel.GuiUtils;
import sc.fiji.labkit.ui.segmentation.weka.PixelClassificationPlugin;
import sc.fiji.labkit.ui.utils.progress.SwingProgressWriter;

public class TrainClassifier {
    private final SegmenterListModel model;

    public TrainClassifier(Extensible extensible, SegmenterListModel model) {
        this.model = model;
        extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Train Classifier", 1.0f, this::onTrainClicked, GuiUtils.loadIcon("run.png"), "ctrl shift T");
        extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Remove Classifier", 3.0f, model::remove, GuiUtils.loadIcon("remove.png"), null);
    }

    private void onTrainClicked(SegmentationItem item) {
        if (item != null) {
            this.model.selectedSegmenter().set(item);
        }
        this.trainSelectedSegmenter();
    }

    public void trainSelectedSegmenter() {
        if (this.model.selectedSegmenter().get() == null) {
            this.selectSomeSegmenter();
        }
        TrainClassifier.trainSelectedSegmenter(this.model);
    }

    private void selectSomeSegmenter() {
        List<SegmentationItem> list = this.model.segmenters().get();
        SegmentationItem segmentationItem = list.isEmpty() ? this.addNewSegmenter() : list.get(list.size() - 1);
        this.model.selectedSegmenter().set(segmentationItem);
    }

    private SegmentationItem addNewSegmenter() {
        PixelClassificationPlugin plugin = new PixelClassificationPlugin();
        this.model.context().inject((Object)plugin);
        return this.model.addSegmenter(plugin);
    }

    public static void trainSelectedSegmenter(SegmenterListModel model) {
        TrainClassifier.train(model.trainingData().get(), model.selectedSegmenter().get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void train(List<Pair<ImgPlus<?>, Labeling>> trainingData, SegmentationItem item) {
        SwingProgressWriter progressWriter = new SwingProgressWriter(null, "Training in Progress");
        progressWriter.setVisible(true);
        progressWriter.setProgressBarVisible(false);
        progressWriter.setDetailsVisible(false);
        try {
            item.train(trainingData);
        }
        catch (CancellationException e) {
            progressWriter.setVisible(false);
            JOptionPane.showMessageDialog(null, e.getMessage(), "Training Cancelled", -1);
        }
        catch (Throwable e) {
            progressWriter.setVisible(false);
            JOptionPane.showMessageDialog(null, e.toString(), "Training Failed", 2);
            e.printStackTrace();
        }
        finally {
            progressWriter.setVisible(false);
        }
    }
}

