/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.utils;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberAwareStringComparator
implements Comparator<CharSequence> {
    private static final NumberAwareStringComparator INSTANCE = new NumberAwareStringComparator();
    private static final Pattern PATTERN = Pattern.compile("(\\D*)(\\d*)");

    public static Comparator<CharSequence> getInstance() {
        return INSTANCE;
    }

    private NumberAwareStringComparator() {
    }

    @Override
    public int compare(CharSequence a, CharSequence b) {
        Matcher matcherA = PATTERN.matcher(a);
        Matcher matcherB = PATTERN.matcher(b);
        while (matcherA.find() && matcherB.find()) {
            int nonDigitCompare = matcherA.group(1).compareTo(matcherB.group(1));
            if (0 != nonDigitCompare) {
                return nonDigitCompare;
            }
            String digitsA = matcherA.group(2);
            String digitsB = matcherB.group(2);
            if (digitsA.isEmpty()) {
                return digitsB.isEmpty() ? 0 : -1;
            }
            if (digitsB.isEmpty()) {
                return 1;
            }
            int numberCompare = this.compareNumbers(digitsA, digitsB);
            if (0 == numberCompare) continue;
            return numberCompare;
        }
        return matcherA.hitEnd() && matcherB.hitEnd() ? 0 : (matcherA.hitEnd() ? -1 : 1);
    }

    private int compareNumbers(String digitsA, String digitsB) {
        BigInteger n1 = new BigInteger(digitsA);
        BigInteger n2 = new BigInteger(digitsB);
        int result = n1.compareTo(n2);
        if (result != 0) {
            return result;
        }
        return digitsA.compareTo(digitsB);
    }
}

